/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.portletcache;

import javax.servlet.ServletConfig;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.portletcache.Cacheable;
import org.apache.jetspeed.services.portletcache.GlobalCache;
import org.apache.jetspeed.services.portletcache.PortletCacheService;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.cache.CachedObject;
import org.apache.turbine.services.cache.ObjectExpiredException;
import org.apache.turbine.services.cache.Refreshable;
import org.apache.turbine.services.cache.RefreshableCachedObject;

public class JetspeedPortletCacheService
extends TurbineBaseService
implements PortletCacheService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortletCacheService.class.getName());
    private static int DefaultTimeToLiveMillis = JetspeedResources.getInt("services.PortletCache.TimeToLive.default", 1800000);

    public void init(ServletConfig config) {
        try {
            logger.info("JetspeedPortletCacheService early init()....starting!");
            if (DefaultTimeToLiveMillis < 0) {
                logger.info("JetspeedPortletCacheService - By default refreshable objects will live for ever");
            } else {
                logger.info("JetspeedPortletCacheService - By default refreshable objects will be removed after " + DefaultTimeToLiveMillis + " Millis ( " + DefaultTimeToLiveMillis / 60000 + " minutes " + (double)(DefaultTimeToLiveMillis % 60000) / 1000.0 + " Seconds " + ")");
            }
            logger.info("JetspeedPortletCacheService early init()....finished!");
        }
        catch (Exception e) {
            logger.error("Cannot initialize JetspeedPortletCacheService!", e);
        }
        this.setInit(true);
    }

    public void addCacheable(Cacheable item) {
        String handle = item.getHandle();
        if (handle.length() == 0) {
            throw new RuntimeException("You must specify a handle for the item you want to cache.");
        }
        if (item.isCacheable()) {
            CachedObject cachedObject = null;
            Long expirationMillis = item.getExpirationMillis();
            if (expirationMillis != null && System.currentTimeMillis() < expirationMillis) {
                cachedObject.setExpires(expirationMillis - cachedObject.getCreated());
            }
            if (item instanceof Refreshable) {
                RefreshableCachedObject rco = new RefreshableCachedObject((Refreshable)item);
                if (item instanceof AbstractPortlet) {
                    AbstractPortlet portlet = (AbstractPortlet)item;
                    String tempString = portlet.getPortletConfig().getInitParameter("_TimeToLive");
                    if (tempString != null) {
                        rco.setTTL((long)Integer.parseInt(tempString));
                        if (logger.isWarnEnabled()) {
                            logger.warn("PortletCache: portlet " + item.getHandle() + " overrides default time to live with " + tempString);
                        }
                    } else {
                        rco.setTTL((long)DefaultTimeToLiveMillis);
                    }
                } else {
                    rco.setTTL((long)DefaultTimeToLiveMillis);
                }
                cachedObject = rco;
            } else {
                cachedObject = new CachedObject((Object)item);
            }
            item.setCachedObject(cachedObject);
            GlobalCache.addObject(handle, cachedObject);
        }
    }

    public void removeCacheable(String handle) {
        CachedObject obj = null;
        try {
            obj = GlobalCache.getObject(handle);
        }
        catch (ObjectExpiredException objectExpiredException) {
            // empty catch block
        }
        if (obj != null) {
            obj.setStale(true);
        }
    }

    public Cacheable getCacheable(String handle) {
        CachedObject obj = null;
        try {
            obj = GlobalCache.getObject(handle);
        }
        catch (ObjectExpiredException e) {
            logger.info("cache miss, object expired: " + handle);
        }
        if (obj == null) {
            return null;
        }
        return (Cacheable)obj.getContents();
    }
}

