/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.registry;

import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.registry.FileRegistry;
import org.apache.jetspeed.services.registry.RegistryFragment;

public class RegistryWatcher
extends Thread {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RegistryWatcher.class.getName());
    public static final int SCAN_RATE = 10;
    private Hashtable files = new Hashtable();
    private long refreshRate = 0L;
    private FileRegistry subscriber = null;
    private FileFilter filter = null;
    private boolean done = false;

    public RegistryWatcher() {
        this.setDaemon(true);
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscriber(FileRegistry registry) {
        RegistryWatcher registryWatcher = this;
        synchronized (registryWatcher) {
            Enumeration en;
            if (this.subscriber != null) {
                en = this.files.keys();
                while (en.hasMoreElements()) {
                    try {
                        this.subscriber.removeFragment(((File)en.nextElement()).getCanonicalPath());
                    }
                    catch (Exception e) {
                        logger.error("RegistryWatcher: Can't remove fragment", e);
                    }
                }
            }
            this.subscriber = registry;
            if (this.subscriber != null) {
                en = this.files.keys();
                while (en.hasMoreElements()) {
                    try {
                        this.subscriber.loadFragment(((File)en.nextElement()).getCanonicalPath());
                    }
                    catch (Exception e) {
                        logger.error("RegistryWatcher: Can't load fragment", e);
                    }
                }
            }
        }
    }

    public FileRegistry getSubscriber() {
        return this.subscriber;
    }

    public void setRefreshRate(long refresh) {
        this.refreshRate = (refresh > 10L ? refresh : 10L) * 1000L;
    }

    public long getRefreshRate() {
        return this.refreshRate / 1000L;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBase(File f) {
        RegistryWatcher registryWatcher = this;
        synchronized (registryWatcher) {
            if (this.subscriber != null) {
                Enumeration en = this.files.keys();
                while (en.hasMoreElements()) {
                    try {
                        this.subscriber.removeFragment(((File)en.nextElement()).getCanonicalPath());
                    }
                    catch (Exception e) {
                        logger.error("RegistryWatcher: Can't remove fragment", e);
                    }
                }
            }
            this.files.clear();
            this.findFiles(f);
        }
    }

    private void findFiles(File f) {
        File[] contents = null;
        if (f.exists() && f.canRead()) {
            this.files.put(f, new Long(f.lastModified()));
            if (f.isDirectory() && (contents = this.filter != null ? f.listFiles(this.filter) : f.listFiles()) != null) {
                for (int i = 0; i < contents.length; ++i) {
                    this.files.put(contents[i], new Long(contents[i].lastModified()));
                    if (this.subscriber == null) continue;
                    try {
                        this.subscriber.loadFragment(contents[i].getCanonicalPath());
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("RegistryWatcher: Can't load fragment", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.done) {
                boolean needRefresh = false;
                RegistryWatcher registryWatcher = this;
                synchronized (registryWatcher) {
                    Map fragments = this.subscriber.getFragmentMap();
                    if (logger.isDebugEnabled()) {
                        logger.debug("RegistryWatcher: Saving dirty fragments.");
                    }
                    Iterator i = fragments.keySet().iterator();
                    while (i.hasNext()) {
                        try {
                            String filename = (String)i.next();
                            RegistryFragment fragment = (RegistryFragment)this.subscriber.getFragmentMap().get(filename);
                            if (!fragment.isDirty()) continue;
                            this.subscriber.saveFragment(filename);
                            if (logger.isDebugEnabled()) {
                                logger.debug("RegistryWatcher: Saved " + filename);
                            }
                            Enumeration en = this.files.keys();
                            while (en.hasMoreElements()) {
                                File f = (File)en.nextElement();
                                if (!filename.equals(f.getCanonicalPath())) continue;
                                this.files.put(f, new Long(f.lastModified()));
                            }
                        }
                        catch (Exception e) {
                            logger.error("RegistryWatcher: exception during update", e);
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("RegistryWatcher: Checking for updated files.");
                    }
                    Enumeration en = this.files.keys();
                    while (en.hasMoreElements()) {
                        try {
                            RegistryFragment frag;
                            File f = (File)en.nextElement();
                            long modified = (Long)this.files.get(f);
                            if (!f.exists()) {
                                this.files.remove(f);
                                continue;
                            }
                            if (f.lastModified() <= modified) continue;
                            this.files.put(f, new Long(f.lastModified()));
                            if (f.isDirectory()) {
                                File[] contents = null;
                                contents = this.filter != null ? f.listFiles(this.filter) : f.listFiles();
                                if (contents != null) {
                                    for (int idx = 0; idx < contents.length; ++idx) {
                                        if (this.files.get(contents[idx]) != null) continue;
                                        this.files.put(contents[idx], new Long(contents[idx].lastModified()));
                                        if (this.subscriber == null) continue;
                                        this.subscriber.loadFragment(contents[idx].getCanonicalPath());
                                    }
                                }
                            } else {
                                this.subscriber.loadFragment(f.getCanonicalPath());
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("RegistryWatcher: Refreshing because " + f.getCanonicalPath() + " was modified.(" + f.lastModified() + " " + modified + ")");
                            }
                            if ((frag = (RegistryFragment)fragments.get(f.getCanonicalPath())) != null) {
                                frag.setChanged(true);
                            }
                            needRefresh = true;
                        }
                        catch (Exception e) {
                            logger.error("RegistryWatcher: exception during update", e);
                        }
                    }
                    if (needRefresh) {
                        this.subscriber.refresh();
                        needRefresh = false;
                    }
                    i = fragments.keySet().iterator();
                    while (i.hasNext()) {
                        RegistryFragment frag = (RegistryFragment)fragments.get((String)i.next());
                        frag.setDirty(false);
                        frag.setChanged(false);
                    }
                }
                RegistryWatcher.sleep(this.refreshRate);
            }
        }
        catch (InterruptedException e) {
            logger.error("RegistryWatcher: Stopping monitor: ", e);
            return;
        }
    }

    public void setDone() {
        this.done = true;
        logger.info("RegistryWatcher: Watching thread stop requested");
    }
}

