/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResourceService;

public class JetspeedResourceService
extends TurbineResourceService {
    public boolean getBoolean(String name) {
        return new Boolean(this.interpolate(this.getConfiguration().getString(name)));
    }

    public boolean getBoolean(String name, boolean def) {
        String temp = this.interpolate(this.getConfiguration().getString(name));
        return temp != null ? new Boolean(temp) : def;
    }

    public double getDouble(String name) {
        return new Double(this.interpolate(this.getConfiguration().getString(name)));
    }

    public double getDouble(String name, double def) {
        String temp = this.interpolate(this.getConfiguration().getString(name));
        return temp != null ? new Double(temp) : def;
    }

    public float getFloat(String name) {
        return new Float(this.interpolate(this.getConfiguration().getString(name))).floatValue();
    }

    public float getFloat(String name, float def) {
        String temp = this.interpolate(this.getConfiguration().getString(name));
        return temp != null ? new Float(temp).floatValue() : def;
    }

    public int getInt(String name) {
        return new Integer(this.interpolate(this.getConfiguration().getString(name)));
    }

    public int getInt(String name, int def) {
        String temp = this.interpolate(this.getConfiguration().getString(name));
        return temp != null ? new Integer(temp) : def;
    }

    public long getLong(String name) {
        return new Long(this.interpolate(this.getConfiguration().getString(name)));
    }

    public long getLong(String name, long def) {
        String temp = this.interpolate(this.getConfiguration().getString(name));
        return temp != null ? new Long(temp) : def;
    }

    public ResourceService getResources(String prefix) {
        Configuration config = this.getConfiguration().subset(prefix);
        if (config == null) {
            return null;
        }
        JetspeedResourceService res = new JetspeedResourceService();
        try {
            res.init(config);
        }
        catch (Exception e) {
            System.err.println("Exception in init of JetspeedResourceService" + e.getMessage());
            e.printStackTrace();
        }
        return res;
    }

    public void init() throws InitializationException {
        System.out.println("Jetspeed Services: Starting with no parameters");
        super.init();
    }

    public synchronized void init(ServletConfig config) throws InitializationException {
        String propsDir = null;
        String appName = config.getServletName();
        String deployFilename = appName + ".properties";
        String torqueFilename = appName + "_torque.properties";
        super.init(config);
        String version = this.getString("jetspeed.version");
        String name = this.getString("jetspeed.name");
        if (version != null && name != null) {
            System.out.println("");
            System.out.println("Starting " + name + "/" + version);
            System.out.println("");
        }
        try {
            propsDir = System.getProperty("jetspeed.conf.dir", null);
            if (null == propsDir) {
                return;
            }
            String torqueProps = this.makeFileNamePath(propsDir, torqueFilename);
            String deployProps = this.makeFileNamePath(propsDir, deployFilename);
            System.out.println("torque props = " + torqueProps);
            System.out.println("deploy props = " + deployProps);
            File deployFile = new File(deployProps);
            if (deployFile.exists()) {
                FileInputStream is = new FileInputStream(deployProps);
                Properties props = new Properties();
                props.load(is);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    this.setProperty((String)entry.getKey(), (String)entry.getValue());
                    System.out.println("setting key/value: " + entry.getKey() + ":" + entry.getValue());
                }
            } else {
                String msg = "Failed to find Deploy properties: " + deployProps;
                System.err.println(msg);
            }
            File torqueFile = new File(torqueProps);
            if (torqueFile.exists()) {
                this.setProperty("component.torque.config", torqueProps);
                FileInputStream tis = new FileInputStream(torqueProps);
                Properties tprops = new Properties();
                tprops.load(tis);
                System.out.println("Connecting to: " + tprops.getProperty("database.default.url"));
                System.out.println("Database Username: " + tprops.getProperty("database.default.username"));
            }
        }
        catch (IOException e) {
            StringBuffer msg = new StringBuffer("Error reading properties for appName: ");
            msg.append(appName);
            msg.append(", props Dir: " + propsDir);
            System.err.println("Exception in loading properties: " + propsDir);
            e.printStackTrace();
        }
    }

    protected String makeFileNamePath(String propsDir, String fileName) {
        StringBuffer name = new StringBuffer(propsDir);
        if (!propsDir.endsWith(File.separator)) {
            name.append(File.separator);
        }
        name.append(fileName);
        return name.toString();
    }
}

