/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.JetspeedPortalAccessController;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.JetspeedSecurityService;
import org.apache.jetspeed.services.security.UserException;
import org.apache.jetspeed.services.security.UserLogonStats;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedDBSecurityService
extends TurbineBaseService
implements JetspeedSecurityService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedDBSecurityService.class.getName());
    private static final String CONFIG_CASEINSENSITIVE_USERNAME = "caseinsensitive.username";
    private static final String CONFIG_CASEINSENSITIVE_PASSWORD = "caseinsensitive.password";
    private static final String CONFIG_CASEINSENSITIVE_UPPER = "caseinsensitive.upper";
    private static final String CONFIG_LOGON_STRIKE_COUNT = "logon.strike.count";
    private static final String CONFIG_LOGON_STRIKE_MAX = "logon.strike.max";
    private static final String CONFIG_LOGON_STRIKE_INTERVAL = "logon.strike.interval";
    private static final String CONFIG_LOGON_AUTO_DISABLE = "logon.auto.disable";
    private static final String CONFIG_ACTIONS_ANON_DISABLE = "actions.anon.disable";
    private static final String CONFIG_ACTIONS_ALLUSERS_DISABLE = "actions.allusers.disable";
    private static final String CONFIG_ACTIONS_ADMIN_ROLES = "admin.roles";
    private static final String CONFIG_NEWUSER_ROLES = "newuser.roles";
    private static final String CONFIG_DEFAULT_PERMISSION_LOGGEDIN = "permission.default.loggedin";
    private static final String CONFIG_DEFAULT_PERMISSION_ANONYMOUS = "permission.default.anonymous";
    private static final String CONFIG_ANONYMOUS_USER = "user.anonymous";
    private static final String[] DEFAULT_PERMISSIONS = new String[]{""};
    private static final String[] DEFAULT_CONFIG_NEWUSER_ROLES = new String[]{"user"};
    private static final String[] DEFAULT_ADMIN_ROLES = new String[]{"admin"};
    String[] roles = null;
    boolean caseInsensitiveUsername = false;
    boolean caseInsensitivePassword = false;
    boolean caseInsensitiveUpper = true;
    boolean actionsAnonDisable = true;
    boolean actionsAllUsersDisable = false;
    String anonymousUser = "anon";
    String[] adminRoles = null;
    int strikeCount = 3;
    int strikeMax = 20;
    long strikeInterval = 300L;
    boolean autoLogonDisable = false;
    private static HashMap users = new HashMap();
    private static Object sem = new Object();

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        try {
            this.roles = serviceConf.getStringArray(CONFIG_NEWUSER_ROLES);
            this.adminRoles = serviceConf.getStringArray(CONFIG_ACTIONS_ADMIN_ROLES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.roles || this.roles.length == 0) {
            this.roles = DEFAULT_CONFIG_NEWUSER_ROLES;
        }
        if (null == this.adminRoles || this.adminRoles.length == 0) {
            this.adminRoles = DEFAULT_ADMIN_ROLES;
        }
        this.caseInsensitiveUsername = serviceConf.getBoolean(CONFIG_CASEINSENSITIVE_USERNAME, this.caseInsensitiveUsername);
        this.caseInsensitivePassword = serviceConf.getBoolean(CONFIG_CASEINSENSITIVE_PASSWORD, this.caseInsensitivePassword);
        this.caseInsensitiveUpper = serviceConf.getBoolean(CONFIG_CASEINSENSITIVE_UPPER, this.caseInsensitiveUpper);
        this.strikeCount = serviceConf.getInt(CONFIG_LOGON_STRIKE_COUNT, this.strikeCount);
        this.strikeInterval = serviceConf.getLong(CONFIG_LOGON_STRIKE_INTERVAL, this.strikeInterval);
        this.strikeMax = serviceConf.getInt(CONFIG_LOGON_STRIKE_MAX, this.strikeMax);
        this.autoLogonDisable = serviceConf.getBoolean(CONFIG_LOGON_AUTO_DISABLE, this.autoLogonDisable);
        this.actionsAnonDisable = serviceConf.getBoolean(CONFIG_ACTIONS_ANON_DISABLE, this.actionsAnonDisable);
        this.actionsAllUsersDisable = serviceConf.getBoolean(CONFIG_ACTIONS_ALLUSERS_DISABLE, this.actionsAllUsersDisable);
        this.anonymousUser = serviceConf.getString(CONFIG_ANONYMOUS_USER, this.anonymousUser);
        this.setInit(true);
    }

    public JetspeedUser getUserInstance() {
        try {
            return JetspeedUserFactory.getInstance();
        }
        catch (UserException e) {
            return null;
        }
    }

    public String convertUserName(String username) {
        if (this.caseInsensitiveUsername) {
            username = this.caseInsensitiveUpper ? username.toUpperCase() : username.toLowerCase();
        }
        return username;
    }

    public String convertPassword(String password) {
        if (this.caseInsensitivePassword) {
            password = this.caseInsensitiveUpper ? password.toUpperCase() : password.toLowerCase();
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDisableAccount(String username) {
        boolean disabled;
        UserLogonStats stat = (UserLogonStats)users.get(username = this.convertUserName(username));
        if (stat == null) {
            stat = new UserLogonStats(username);
            Object object = sem;
            synchronized (object) {
                users.put(username, stat);
            }
        }
        if (disabled = stat.failCheck(this.strikeCount, this.strikeInterval, this.strikeMax)) {
            try {
                JetspeedUser user = JetspeedSecurity.getUser(username);
                if (user != null) {
                    user.setDisabled("T");
                    JetspeedSecurity.saveUser(user);
                }
            }
            catch (Exception e) {
                logger.error("Could not disable user: " + username, e);
            }
        }
        return disabled;
    }

    public boolean isDisableAccountCheckEnabled() {
        return this.autoLogonDisable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDisableAccountCheck(String username) {
        UserLogonStats stat = (UserLogonStats)users.get(username = this.convertUserName(username));
        if (stat == null) {
            stat = new UserLogonStats(username);
            Object object = sem;
            synchronized (object) {
                users.put(username, stat);
            }
        }
        stat.reset();
    }

    public JetspeedUser getUser(String username) throws JetspeedSecurityException {
        return JetspeedUserManagement.getUser(new UserNamePrincipal(username));
    }

    public boolean checkPermission(JetspeedRunData runData, String action, Portlet portlet) {
        return JetspeedPortalAccessController.checkPermission(runData.getJetspeedUser(), portlet, action);
    }

    public boolean areActionsDisabledForAnon() {
        return this.actionsAnonDisable;
    }

    public boolean areActionsDisabledForAllUsers() {
        return this.actionsAllUsersDisable;
    }

    public String getAnonymousUserName() {
        return this.anonymousUser;
    }

    public List getAdminRoles() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.adminRoles.length; ++i) {
            result.add(this.adminRoles[i]);
        }
        return result;
    }

    public boolean hasAdminRole(User user) {
        String username = user.getUserName();
        try {
            List adminRoles = this.getAdminRoles();
            Iterator it = adminRoles.iterator();
            while (it.hasNext()) {
                if (!JetspeedSecurity.hasRole(username, (String)it.next())) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return false;
    }
}

