/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.statemanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.jetspeed.services.statemanager.StateManagerService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.RunData;

public abstract class BaseStateManagerService
extends TurbineBaseService
implements StateManagerService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseStateManagerService.class.getName());
    protected Map m_httpSessions = null;

    protected abstract void initStates();

    protected abstract void shutdownStates();

    protected abstract Map getState(String var1);

    protected abstract void addState(String var1, Map var2);

    protected abstract void removeState(String var1);

    protected abstract String[] getStateKeys(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retireAttributes(String key, Map state) {
        if (state == null) {
            return;
        }
        Set attributes = state.entrySet();
        Map map = state;
        synchronized (map) {
            for (Map.Entry attribute : attributes) {
                this.unBindAttributeValue(key, (String)attribute.getKey(), attribute.getValue());
            }
        }
        state.clear();
    }

    protected void unBindAttributeValue(String stateKey, String attributeName, Object attribute) {
        if (attribute != null && attribute instanceof SessionStateBindingListener) {
            try {
                ((SessionStateBindingListener)attribute).valueUnbound(stateKey, attributeName);
            }
            catch (Throwable e) {
                logger.warn("JetspeedStateManagerService.unBindAttributeValue: unbinding exception: ", e);
            }
        }
    }

    protected void bindAttributeValue(String stateKey, String attributeName, Object attribute) {
        if (attribute != null && attribute instanceof SessionStateBindingListener) {
            try {
                ((SessionStateBindingListener)attribute).valueBound(stateKey, attributeName);
            }
            catch (Throwable e) {
                logger.warn("JetspeedStateManagerService.bindAttributeValue: unbinding exception: ", e);
            }
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_httpSessions = Collections.synchronizedMap(new HashMap());
        this.initStates();
    }

    public void shutdown() {
        this.m_httpSessions.clear();
        this.m_httpSessions = null;
        this.shutdownStates();
        super.shutdown();
    }

    public Object getAttribute(String key, String name) {
        Map state = this.getState(key);
        if (state == null) {
            return null;
        }
        return state.get(name);
    }

    public void setAttribute(String key, String name, Object value) {
        Map<String, Object> state = this.getState(key);
        if (state == null) {
            state = Collections.synchronizedMap(new HashMap());
            this.addState(key, state);
        }
        Object old = this.getAttribute(key, name);
        state.put(name, value);
        if (old != null) {
            this.unBindAttributeValue(key, name, old);
        }
        this.bindAttributeValue(key, name, value);
    }

    public void removeAttribute(String key, String name) {
        Map state = this.getState(key);
        if (state == null) {
            return;
        }
        Object old = this.getAttribute(key, name);
        state.remove(name);
        if (state.isEmpty()) {
            this.removeState(key);
        }
        if (old != null) {
            this.unBindAttributeValue(key, name, old);
        }
    }

    public void clear(String key) {
        Map state = this.getState(key);
        if (state == null) {
            return;
        }
        this.retireAttributes(key, state);
        this.removeState(key);
    }

    public String[] getAttributeNames(String key) {
        Map state = this.getState(key);
        if (state == null) {
            return null;
        }
        if (state.size() == 0) {
            return null;
        }
        return state.keySet().toArray(new String[state.size()]);
    }

    public SessionState getSessionState(String key) {
        return new MySessionState(key, this);
    }

    public SessionState getCurrentSessionState() {
        HttpSession session = (HttpSession)this.m_httpSessions.get(Thread.currentThread());
        if (session == null) {
            return null;
        }
        return this.getSessionState(session.getId());
    }

    public SessionState getCurrentSessionState(String key) {
        HttpSession session = (HttpSession)this.m_httpSessions.get(Thread.currentThread());
        if (session == null) {
            return null;
        }
        return this.getSessionState(session.getId() + key);
    }

    public synchronized void retireState(String keyStart) {
        String[] keys = this.getStateKeys(keyStart);
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            this.clear(keys[i]);
        }
    }

    public void setCurrentContext(HttpSession session) {
        this.m_httpSessions.put(Thread.currentThread(), session);
    }

    public void clearCurrentContext() {
        this.m_httpSessions.remove(Thread.currentThread());
    }

    private class MySessionState
    implements SessionState {
        private String m_key = null;
        private BaseStateManagerService m_service = null;

        public MySessionState(String key, BaseStateManagerService service) {
            this.m_key = key;
            this.m_service = service;
        }

        public Object getAttribute(String name) {
            return this.m_service.getAttribute(this.m_key, name);
        }

        public void setAttribute(String name, Object value) {
            this.m_service.setAttribute(this.m_key, name, value);
        }

        public void removeAttribute(String name) {
            this.m_service.removeAttribute(this.m_key, name);
        }

        public void clear() {
            this.m_service.clear(this.m_key);
        }

        public String[] getAttributeNames() {
            return this.m_service.getAttributeNames(this.m_key);
        }

        public String getKey() {
            return this.m_key;
        }

        public void retire() {
            this.m_service.retireState(this.m_key);
        }
    }
}

