/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import org.apache.jetspeed.services.webpage.WebPageHelper;
import org.apache.log4j.Logger;

public class Configuration {
    public static final String WPS_SERVLET = "/wps";
    public static final int STATUS_NOT_CONFIGURED = 0;
    public static final int STATUS_ONLINE = 1;
    public static final int STATUS_OFFLINE = -1;
    static Logger log = Logger.getLogger(Configuration.class);
    public static final String KEY_WPS_SID = "wps.sid";
    public static final String WPS_SID = "wpsid";
    private String sid = "wpsid";
    public static final String KEY_WPS_PATH = "wps.path";
    public static final String WPS_PATH = "wpspath";
    private String path = "wpspath";
    public static final String KEY_WPS_URL = "wps.url";
    public static final String WPS_URL = "wps.url";
    private String url = "wps.url";
    public static final String KEY_WPS_DEBUG = "wps.debug";
    private boolean debug = false;
    public static final String KEY_PARSER = "parser.default";
    public static final String PARSER_SWING = "swing";
    public static final String PARSER_OPENXML = "openxml";
    private String parser = "swing";
    public static final String KEY_LOG_ENABLE = "log.content.enable";
    private boolean enableContentLog = false;
    public static final String KEY_LOG_LOCATION = "log.content.location";
    public static final String WPS_LOG_LOCATION = "/WEB-INF/logs/wps-content.log";
    private String logLocation = "/WEB-INF/logs/wps-content.log";
    public static final String KEY_LOG_RESET = "log.content.reset";
    private boolean resetContentLog = false;
    public static final String KEY_WEBAPP = "wps.webapp.name";
    public static final String WPS_WEBAPP = "/jetspeed";
    private String webapp = "/jetspeed";
    public static final String KEY_LOGIN = "ne.webapp.login";
    public static final String WPS_LOGIN = "/jetspeed/loginController.php";
    private String login = "/jetspeed/loginController.php";
    public static final String KEY_LOGOUT = "ne.webapp.logout";
    public static final String WPS_LOGOUT = "/jetspeed/logoutController.php";
    private String logout = "/jetspeed/logoutController.php";
    public static final String KEY_USER_SESSION = "user.session.key";
    public static final String WPS_USER_SESSION = "turbine.user";
    private String userSessionKey = "turbine.user";
    public static final String KEY_USER_DEFAULT = "user.default";
    public static final String WPS_USER_DEFAULT = "joe";
    private String userDefault = "joe";
    public static final String KEY_PARAM_USER = "ne.webapp.param.username";
    public static final String WPS_PARAM_USER = "da_username";
    private String paramUser = "da_username";
    public static final String KEY_PARAM_PASSWORD = "webapp.param.password";
    public static final String WPS_PARAM_PASSWORD = "da_password";
    private String paramPassword = "da_password";
    public static final String KEY_PARAM_PERMISSIONS = "webapp.param.permissions";
    public static final String WPS_PARAM_PERMISSIONS = "serialized_permissions";
    private String paramPermissions = "serialized_permissions";
    public static final String KEY_LOGIN_FAILURE = "webapp.login.failure";
    public static final String WPS_LOGIN_FAILURE = "LOGIN FAIL";
    private String loginFailureString = "LOGIN FAIL";
    public static final String KEY_LOGIN_SUCCESS = "webapp.login.success";
    public static final String WPS_LOGIN_SUCCESS = "LOGIN SUCCESS";
    private String loginSuccessString = "LOGIN SUCCESS";
    public static final String KEY_CONTENT_INFO = "content.info";
    public static final String KEY_CONTENT_ERROR = "content.error";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    private static Configuration instance = null;
    private Properties properties;
    private String ppath;
    public static final String HEADER = "Jetspeed Web Page Service Configuration Properties";

    public static Configuration getInstance() {
        return instance;
    }

    public static Configuration getInitialInstance(String ppath) throws ServletException {
        if (instance == null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(ppath));
                instance = new Configuration(properties, ppath);
                instance.refresh();
            }
            catch (Exception e) {
                log.debug((Object)e.toString());
                instance = null;
            }
        }
        return instance;
    }

    private Configuration(Properties properties, String ppath) {
        this.properties = properties;
        this.ppath = ppath;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        FileOutputStream out;
        this.properties.setProperty(name, value);
        try {
            out = new FileOutputStream(this.ppath);
            this.properties.store(out, HEADER);
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            String error = "Unable to update configuration file " + this.ppath + e.toString();
            log.debug((Object)error);
        }
        catch (SecurityException e) {
            String error = "Unable to update configuration file " + this.ppath + e.toString();
            log.debug((Object)error);
        }
        catch (IOException e) {
            String error = "Error updating configuration file " + this.ppath + e.toString();
            log.debug((Object)error);
        }
        out = null;
    }

    public void refresh() {
        String result = Configuration.getInstance().getProperty(KEY_WPS_DEBUG);
        this.debug = null == result ? false : result.equalsIgnoreCase(TRUE_VALUE);
        this.sid = Configuration.getInstance().getProperty(KEY_WPS_SID);
        if (null == this.sid) {
            this.sid = WPS_SID;
        }
        this.path = Configuration.getInstance().getProperty(KEY_WPS_PATH);
        if (null == this.path) {
            this.path = WPS_PATH;
        }
        this.url = Configuration.getInstance().getProperty("wps.url");
        if (null == this.url) {
            this.url = "wps.url";
        }
        this.parser = Configuration.getInstance().getProperty(KEY_PARSER);
        if (null == this.parser) {
            this.parser = PARSER_SWING;
        }
        this.enableContentLog = null == (result = Configuration.getInstance().getProperty(KEY_LOG_ENABLE)) ? false : result.equalsIgnoreCase(TRUE_VALUE);
        this.logLocation = Configuration.getInstance().getProperty(KEY_LOG_LOCATION);
        if (null == this.logLocation) {
            this.logLocation = WPS_LOG_LOCATION;
        }
        this.resetContentLog = null == (result = Configuration.getInstance().getProperty(KEY_LOG_RESET)) ? false : result.equalsIgnoreCase(TRUE_VALUE);
        this.webapp = Configuration.getInstance().getProperty(KEY_WEBAPP);
        if (null == this.webapp) {
            this.webapp = WPS_WEBAPP;
        }
        this.login = Configuration.getInstance().getProperty(KEY_LOGIN);
        if (null == this.login) {
            this.login = WPS_LOGIN;
        }
        this.logout = Configuration.getInstance().getProperty(KEY_LOGOUT);
        if (null == this.logout) {
            this.login = WPS_LOGOUT;
        }
        this.userSessionKey = Configuration.getInstance().getProperty(KEY_USER_SESSION);
        if (null == this.userSessionKey) {
            this.userSessionKey = WPS_USER_SESSION;
        }
        this.userDefault = Configuration.getInstance().getProperty(KEY_USER_DEFAULT);
        if (null == this.userDefault) {
            this.userDefault = WPS_USER_DEFAULT;
        }
        this.paramUser = Configuration.getInstance().getProperty(KEY_PARAM_USER);
        if (null == this.paramUser) {
            this.paramUser = WPS_PARAM_USER;
        }
        this.paramPassword = Configuration.getInstance().getProperty(KEY_PARAM_PASSWORD);
        if (null == this.paramPassword) {
            this.paramPassword = WPS_PARAM_PASSWORD;
        }
        this.paramPermissions = Configuration.getInstance().getProperty(KEY_PARAM_PERMISSIONS);
        if (null == this.paramPermissions) {
            this.paramPermissions = WPS_PARAM_PERMISSIONS;
        }
        this.loginFailureString = Configuration.getInstance().getProperty(KEY_LOGIN_FAILURE);
        if (null == this.loginFailureString) {
            this.loginFailureString = WPS_LOGIN_FAILURE;
        }
        this.loginSuccessString = Configuration.getInstance().getProperty(KEY_LOGIN_SUCCESS);
        if (null == this.loginSuccessString) {
            this.loginSuccessString = WPS_LOGIN_SUCCESS;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String getSID() {
        return this.sid;
    }

    public String getPath() {
        return this.path;
    }

    public String getURL() {
        return this.url;
    }

    public String getParser() {
        return this.parser;
    }

    public boolean getEnableContentLog() {
        return this.enableContentLog;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public boolean getResetContentLog() {
        return this.resetContentLog;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public String getLogin() {
        return this.login;
    }

    public String getLogout() {
        return this.logout;
    }

    public String getUserSessionKey() {
        return this.userSessionKey;
    }

    public String getDefaultUser() {
        return this.userDefault;
    }

    public String getParamUser() {
        return this.paramUser;
    }

    public String getParamPassword() {
        return this.paramPassword;
    }

    public String getParamPermissions() {
        return this.paramPermissions;
    }

    public String getLoginFailureString() {
        return this.loginFailureString;
    }

    public String getLoginSuccessString() {
        return this.loginSuccessString;
    }

    public static String createProxyString(String proxyHost, String neid, String resource, String relativePath) {
        String base = WebPageHelper.concatURLs(proxyHost, WPS_SERVLET);
        StringBuffer buffer = new StringBuffer(base);
        buffer.append("?");
        buffer.append(Configuration.getInstance().getSID());
        buffer.append("=");
        buffer.append(neid);
        buffer.append("&");
        buffer.append(Configuration.getInstance().getPath());
        buffer.append("=");
        if (null != relativePath && !resource.startsWith("/")) {
            buffer.append(relativePath);
        }
        buffer.append(resource.replace('&', '@'));
        String proxiedPath = buffer.toString();
        return proxiedPath;
    }
}

