/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.services.webpage.SiteSession;

public class WebPageHelper {
    public static final int CT_TEXT = 0;
    public static final int CT_BINARY = 1;
    public static final int CT_APPLICATION = 2;
    public static final int CT_HTML = 3;
    public static final int CT_IMAGE = 4;
    public static final int CT_CSS = 5;
    public static final int CT_JS = 6;
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String CONTENT_LOG_HEADER = "------------------------------------------------------";
    private static int id = 0;

    public static int getContentType(String typeString, String resource) {
        int contentType = 3;
        if (null == typeString) {
            if (null == resource) {
                return contentType;
            }
            if (resource.endsWith(".js")) {
                return 6;
            }
            if (resource.endsWith(".gif") || resource.endsWith(".jpg") || resource.endsWith(".png")) {
                return 4;
            }
            if (resource.endsWith(".css")) {
                return 5;
            }
            return contentType;
        }
        if (typeString.equalsIgnoreCase("text/html")) {
            contentType = 3;
        } else if (typeString.startsWith("image")) {
            contentType = 4;
        } else if (typeString.startsWith("text/css")) {
            contentType = 5;
        } else if (typeString.startsWith("text")) {
            contentType = 0;
        } else if (typeString.startsWith("binary")) {
            contentType = 1;
        } else if (typeString.equals("application/x-javascript")) {
            contentType = 6;
        } else if (typeString.startsWith("application")) {
            contentType = 2;
        }
        return contentType;
    }

    public static String buildCookieString(Cookie cookie) {
        StringBuffer buffer = new StringBuffer();
        int version = cookie.getVersion();
        if (version != -1) {
            buffer.append("$Version=\"");
            buffer.append(cookie.getVersion());
            buffer.append("\"; ");
        }
        buffer.append(cookie.getName());
        buffer.append("=");
        buffer.append(cookie.getValue());
        String path = cookie.getPath();
        if (path != null) {
            buffer.append("; path=");
            buffer.append(path);
        }
        String cookieHeader = buffer.toString();
        return cookieHeader;
    }

    public static boolean parseCookies(String cookieHeader, SiteSession session) {
        StringTokenizer st = new StringTokenizer(cookieHeader, " =;");
        boolean firstTime = true;
        Cookie cookie = null;
        while (st.hasMoreTokens()) {
            String value;
            String token = st.nextToken();
            if (firstTime) {
                value = st.nextToken();
                cookie = new Cookie(token, value);
                cookie.setVersion(-1);
                firstTime = false;
                continue;
            }
            if (token.equalsIgnoreCase("path")) {
                cookie.setPath(st.nextToken());
                continue;
            }
            if (token.equalsIgnoreCase("version")) {
                cookie.setVersion(Integer.getInteger(st.nextToken()).intValue());
                continue;
            }
            if (token.equalsIgnoreCase("max-age")) {
                cookie.setMaxAge(Integer.getInteger(st.nextToken()).intValue());
                continue;
            }
            if (token.equalsIgnoreCase("domain")) {
                cookie.setDomain(st.nextToken());
                continue;
            }
            if (token.equalsIgnoreCase("secure")) {
                cookie.setSecure(true);
                continue;
            }
            if (null != cookie) {
                session.addCookieToSession(cookie);
            }
            if (!st.hasMoreTokens()) break;
            value = st.nextToken();
            cookie = new Cookie(token, value);
            cookie.setVersion(-1);
        }
        if (null != cookie) {
            session.addCookieToSession(cookie);
        }
        return null != cookie;
    }

    public static StringBuffer replaceAll(StringBuffer buffer, String find, String replacement) {
        int bufidx = buffer.length() - 1;
        int offset = find.length();
        while (bufidx > -1) {
            int findidx = offset - 1;
            while (findidx > -1) {
                if (bufidx == -1) {
                    return buffer;
                }
                if (buffer.charAt(bufidx) == find.charAt(findidx)) {
                    --findidx;
                    --bufidx;
                    continue;
                }
                findidx = offset - 1;
                if (--bufidx != -1) continue;
                return buffer;
            }
            buffer.replace(bufidx + 1, bufidx + 1 + offset, replacement);
        }
        return buffer;
    }

    public static String concatURLs(String base, String path) {
        String result = "";
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                result = base.concat(path.substring(1));
                return result;
            }
        } else if (!path.startsWith("/")) {
            result = base.concat("/").concat(path);
            return result;
        }
        return base.concat(path);
    }

    public static String getAvailabilityStatus(int status) {
        switch (status) {
            case 0: {
                return "Not Initialized";
            }
            case 1: {
                return "Online";
            }
        }
        return "Offline";
    }

    public static void writeHeader(FileOutputStream fos, String resource) throws IOException {
        fos.write(13);
        fos.write(10);
        fos.write(CONTENT_LOG_HEADER.getBytes());
        fos.write(13);
        fos.write(10);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        fos.write(sdf.format(new Date()).getBytes());
        fos.write(13);
        fos.write(10);
        fos.write(resource.getBytes());
        fos.write(13);
        fos.write(10);
    }

    public static String getIP(String hostname) {
        String ip = null;
        try {
            InetAddress computer = InetAddress.getByName(hostname);
            ip = computer.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }

    public static synchronized long generateId() {
        return ++id;
    }
}

