/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class MetaData
implements Serializable {
    public static final String DEFAULT_TITLE = JetspeedResources.getString("metadata.default.title");
    public static final String DEFAULT_DESCRIPTION = JetspeedResources.getString("metadata.default.description");
    public static final String DEFAULT_IMAGE = JetspeedResources.getString("metadata.default.image");
    private Hashtable data = new Hashtable();

    public void setTitle(String title) {
        this.setTitle(title, null);
    }

    public void setTitle(String title, Locale locale) {
        this.setProperty("title", locale, title);
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(Locale locale) {
        String title = (String)this.getProperty("title", locale);
        if (title == null && locale != null) {
            title = (String)this.getProperty("title", null);
        }
        if (title == null) {
            title = DEFAULT_TITLE;
        }
        return title;
    }

    public void setImage(String image) {
        this.setImage(image, null);
    }

    public void setImage(String image, Locale locale) {
        this.setProperty("image", locale, image);
    }

    public String getImage() {
        return this.getImage(null);
    }

    public String getImage(Locale locale) {
        String image = (String)this.getProperty("image", locale);
        if (image == null && locale != null) {
            image = (String)this.getProperty("image", null);
        }
        if (image == null) {
            image = DEFAULT_IMAGE;
        }
        return image;
    }

    public void setDescription(String description) {
        this.setDescription(description, null);
    }

    public void setDescription(String description, Locale locale) {
        this.setProperty("description", locale, description);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        String desc = (String)this.getProperty("description", locale);
        if (desc == null && locale != null) {
            desc = (String)this.getProperty("description", null);
        }
        if (desc == null) {
            desc = DEFAULT_DESCRIPTION;
        }
        return desc;
    }

    private void setProperty(String name, Locale locale, Object value) {
        if (name == null) {
            return;
        }
        if (locale != null) {
            name = name + "." + locale.toString();
        }
        if (value == null) {
            this.data.remove(name);
        } else {
            this.data.put(name, value);
        }
    }

    private Object getProperty(String name, Locale locale) {
        if (name == null) {
            return null;
        }
        String extname = null;
        if (locale != null) {
            extname = name + "." + locale.toString();
        }
        Object obj = null;
        if (extname != null) {
            obj = this.data.get(extname);
        }
        if (obj == null) {
            obj = this.data.get(name);
        }
        return obj;
    }

    private Map getProperties() {
        return this.data;
    }

    public void merge(MetaData meta) {
        Map map = meta.getProperties();
        Hashtable params = (Hashtable)map;
        Enumeration en = params.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            String value = (String)params.get(key);
            if (value == null) continue;
            this.data.put(key, value);
        }
    }
}

