/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MergeFiles {
    protected static List files;
    protected static String dest_file;
    public static boolean verbose;
    protected static ArrayList baseArray;
    protected static String lineSeparator;

    public static void main(String[] args) throws Exception {
        MergeFiles main = new MergeFiles();
        try {
            int index;
            if (args.length < 2) {
                System.out.println("Usage: java MergeFiles [scratch/drop] c:/temp/all.sql c:/temp/dbpsml.sql c:/temp/populate.sql .... c:/temp/File(n)");
                System.out.println("Usage: If scratch is specified then all sql statements starting with DROP will be overlooked.");
                System.out.println("Usage: If drop is specified then only sql statements starting with DROP will be added.");
                System.out.println("Usage: All the files listed after c:/temp/all.sql will be added to c:/temp/all.sql");
                throw new Exception("Incorrect number of arguments supplied");
            }
            int file_index = 0;
            boolean db_from_scratch = false;
            boolean db_drop = false;
            if (args[0].equals("scratch")) {
                file_index = 1;
                db_from_scratch = true;
            } else if (args[0].equals("drop")) {
                file_index = 1;
                db_drop = true;
            }
            files = new Vector(args.length - 1 - file_index);
            dest_file = args[file_index];
            for (index = file_index + 1; index < args.length; ++index) {
                files.add(args[index]);
            }
            for (index = 0; index < files.size(); ++index) {
                BufferedReader reader = new BufferedReader(new FileReader((String)files.get(index)));
                String line = null;
                int idx = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    if (db_from_scratch) {
                        if (!(line.startsWith("DROP") || line.startsWith("drop") || line.startsWith("Drop"))) {
                            baseArray.add(idx, line);
                            ++idx;
                        }
                    } else if (db_drop) {
                        if (line.startsWith("DROP") || line.startsWith("drop") || line.startsWith("Drop")) {
                            baseArray.add(idx, line);
                            ++idx;
                        }
                    } else {
                        baseArray.add(idx, line);
                        ++idx;
                    }
                    if (!verbose) continue;
                    System.out.println("While reading baseArray[" + idx + "] = " + line);
                }
                reader.close();
            }
            if (verbose) {
                System.out.println("\nMerge Files\n");
            }
            baseArray.add("commit;");
            baseArray.trimToSize();
            main.writeToFile();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (SecurityException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void writeToFile() throws FileNotFoundException, IOException {
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(dest_file);
        }
        catch (FileNotFoundException ex) {
            File file = new File(dest_file);
            writer = new FileOutputStream(file.getPath(), false);
        }
        writer.flush();
        for (int i = 0; i < baseArray.size(); ++i) {
            if (verbose) {
                System.out.println("While writing baseArray[" + i + "] = " + baseArray.get(i));
            }
            writer.write(((String)baseArray.get(i)).getBytes());
            writer.write(lineSeparator.getBytes());
            writer.flush();
        }
        writer.close();
    }

    static {
        dest_file = null;
        verbose = false;
        baseArray = new ArrayList(1024);
        lineSeparator = System.getProperty("line.separator", "\r\n");
    }
}

