/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.webservices.finance.stockmarket;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.XMLFilterImpl;

class SOAPResponseHandler
extends XMLFilterImpl {
    String outputNameSpace = null;
    String outputElementName = null;
    String outputPartElementName = null;
    boolean inSoapEnv = false;
    boolean inSoapBody = false;
    boolean inOperation = false;
    boolean inResult = false;
    boolean debugParse = false;
    StringBuffer resultBuffer = null;
    XMLFilterImpl resultHandler = null;
    int resultElementStack = 0;
    boolean wasFault = false;
    boolean inFault = false;
    boolean inFaultString = false;
    StringBuffer faultContent = null;

    public SOAPResponseHandler(String ns, String en, String pen) {
        this.outputNameSpace = ns;
        this.outputElementName = en;
        this.outputPartElementName = pen;
    }

    public void setContentHandler(ContentHandler handler) {
        this.getParent().setContentHandler(handler);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String uriName = uri + ":" + localName;
        if ("http://schemas.xmlsoap.org/soap/envelope/:Fault".equals(uriName)) {
            if (this.debugParse) {
                System.out.println("Found Fault");
            }
            this.inFault = true;
        } else if (this.inFault && "faultstring".equals(localName)) {
            if (this.debugParse) {
                System.out.println("Found Fault String");
            }
            this.inFaultString = true;
            this.faultContent = new StringBuffer();
        } else if ("http://schemas.xmlsoap.org/soap/envelope/:Envelope".equals(uriName)) {
            if (this.debugParse) {
                System.out.println("Found Envelope");
            }
            this.inSoapEnv = true;
        } else if (this.inSoapEnv && "http://schemas.xmlsoap.org/soap/envelope/:Body".equals(uriName)) {
            if (this.debugParse) {
                System.out.println("Found Body");
            }
            this.inSoapBody = true;
        } else if (this.inSoapBody && (this.outputNameSpace + ":" + this.outputElementName).equals(uriName)) {
            if (this.debugParse) {
                System.out.println("Found operation: " + localName);
            }
            this.inOperation = true;
        } else if (this.inOperation && this.outputPartElementName.equals(localName)) {
            if (attributes.getValue("href") != null) {
                throw new SAXNotSupportedException("href attributes not supported");
            }
            if (this.debugParse) {
                System.out.println("Found Part: " + localName);
            }
            if (this.resultHandler != null) {
                this.resultHandler.setParent(this);
                this.getParent().setContentHandler(this.resultHandler);
            } else {
                this.resultBuffer = new StringBuffer();
            }
            this.inResult = true;
        } else if (!this.inFault) {
            if (this.debugParse) {
                System.out.println("Found Unknown Element: <" + qName + ">    ns:" + uri);
            }
            this.inResult = false;
            this.inSoapEnv = false;
            this.inSoapBody = false;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inResult && this.outputPartElementName.equals(localName)) {
            this.inResult = false;
        } else if ("http://schemas.xmlsoap.org/soap/envelope/:Fault".equals(uri + ":" + localName)) {
            this.wasFault = true;
            this.inFault = false;
        } else if (this.inFault && "faultstring".equals(localName)) {
            this.inFaultString = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inResult) {
            this.resultBuffer.append(new String(ch, start, length));
        }
        if (this.inFault) {
            this.faultContent.append(new String(ch, start, length));
        }
    }

    public String getResult() {
        if (this.resultBuffer == null) {
            return null;
        }
        return this.resultBuffer.toString();
    }

    public void setResultHandler(XMLFilterImpl handler) {
        this.resultHandler = handler;
    }

    public boolean isFault() {
        return this.wasFault;
    }

    public String getFaultContent() {
        if (this.faultContent == null) {
            return "";
        }
        return this.faultContent.toString();
    }
}

