/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.wiki;

import com.aimluck.eip.cayenne.om.portlet.EipTWiki;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.wiki.util.WikiFileUtils;
import com.aimluck.eip.wiki.util.WikiUtils;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WikiMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WikiMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            Expression exp1 = ExpressionFactory.inDbExp((String)"WIKI_ID", values);
            List wikiList = Database.query(EipTWiki.class, (Expression)exp1).fetchList();
            if (wikiList == null || wikiList.size() == 0) {
                return false;
            }
            for (EipTWiki wiki : wikiList) {
                Integer entityId = wiki.getWikiId();
                if (WikiUtils.getChildCount(entityId) > 0) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_HAS_CHILDREN"));
                    return false;
                }
                String wikiName = wiki.getWikiName();
                WikiFileUtils.deleteFiles(wiki.getWikiId());
                Database.delete((Persistent)wiki);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 360, wikiName);
            }
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"WikiMultiDelete.action", t);
            return false;
        }
        return true;
    }
}

