/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.WPTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WPCodeBlock
extends WPTag {
    private String contents = "";
    private Map<String, String> fAttributes = null;

    public WPCodeBlock() {
        super("{code}");
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        buf.append("\n<pre");
        HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
        buf.append(">");
        String rawWikiText = Utils.ltrimNewline((String)this.contents);
        ArrayList<ContentToken> mockNodeList = new ArrayList<ContentToken>();
        ContentToken token = new ContentToken(rawWikiText);
        mockNodeList.add(token);
        converter.nodesToText(mockNodeList, buf, wikiModel);
        buf.append("</pre>");
    }

    public Object clone() {
        WPCodeBlock tt = (WPCodeBlock)((Object)super.clone());
        tt.fAttributes = this.fAttributes == null ? null : new HashMap<String, String>(this.fAttributes);
        return tt;
    }

    public boolean isReduceTokenStack() {
        return true;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }
}

