/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.de.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class GermanAnalyzer
extends Analyzer {
    private String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u00df", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u00fcr", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    private Hashtable stoptable = new Hashtable();
    private Hashtable excltable = new Hashtable();

    public GermanAnalyzer() {
        this.stoptable = StopFilter.makeStopTable(this.GERMAN_STOP_WORDS);
    }

    public GermanAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopTable(stopwords);
    }

    public GermanAnalyzer(Hashtable stopwords) {
        this.stoptable = stopwords;
    }

    public GermanAnalyzer(File stopwords) {
        this.stoptable = WordlistLoader.getWordtable(stopwords);
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.excltable = StopFilter.makeStopTable(exclusionlist);
    }

    public void setStemExclusionTable(Hashtable exclusionlist) {
        this.excltable = exclusionlist;
    }

    public void setStemExclusionTable(File exclusionlist) {
        this.excltable = WordlistLoader.getWordtable(exclusionlist);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new StopFilter(result, this.stoptable);
        result = new GermanStemFilter(result, this.excltable);
        return result;
    }
}

