/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;

public class ALCellDateField
extends ALDateField {
    private static final long serialVersionUID = -8240954278261905509L;

    public ALCellDateField() {
    }

    public ALCellDateField(ALDateContainer container) {
        super(container);
    }

    @Override
    public boolean validate(List<String> msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NAME", this.fieldName));
                return false;
            }
        } else {
            try {
                this.value.getDate();
                int year = this.value.getYear();
                if (year <= 1582) {
                    msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_ERROR_DATE", this.fieldName));
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_ERROR", this.fieldName));
                return false;
            }
            catch (ALIllegalDateException ex) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_ERROR", this.fieldName));
                return false;
            }
        }
        return true;
    }
}

