/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.social.Activity;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityGetRequest;
import com.aimluck.eip.util.ALCommonUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;

public class ALActivity
implements ALData,
Serializable {
    private static final long serialVersionUID = 597816564175622540L;
    private int id;
    private ALStringField displayName;
    private ALStringField appId;
    private ALStringField loginname;
    private ALStringField title;
    private ALDateTimeField updateDate;
    private ALDateTimeField updateDateTime;
    private ALDateTimeField updateYear;
    private ALDateTimeField updateDateYear;
    private ALStringField externalId;
    private ALStringField portletParams;
    private ALStringField icon;
    private ALNumberField moduleId;
    private boolean isRead;

    public ALActivity() {
        this.initField();
    }

    @Override
    public void initField() {
        this.displayName = new ALStringField();
        this.displayName.setValue("_");
        this.appId = new ALStringField();
        this.loginname = new ALStringField();
        this.title = new ALStringField();
        this.externalId = new ALStringField();
        this.portletParams = new ALStringField();
        this.updateDate = new ALDateTimeField("M\u6708d\u65e5");
        this.updateDateTime = new ALDateTimeField("H:mm");
        this.updateYear = new ALDateTimeField("yyyy\u5e74");
        this.updateDateYear = new ALDateTimeField("yyyy\u5e74M\u6708d\u65e5");
        this.icon = new ALStringField();
        this.moduleId = new ALNumberField();
        this.isRead = true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ALStringField getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId.setValue(appId);
    }

    public ALStringField getLoginName() {
        return this.loginname;
    }

    public void setLoginName(String loginname) {
        this.loginname.setValue(loginname);
    }

    public ALStringField getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.setValue(title);
    }

    public void setUpdateDate(Date updateDate) {
        this.updateYear.setValue(updateDate);
        this.updateDateYear.setValue(updateDate);
        this.updateDate.setValue(updateDate);
        this.updateDateTime.setValue(updateDate);
    }

    public ALDateTimeField getUpdateDate() {
        ALDateTimeField today = new ALDateTimeField("M\u6708d\u65e5");
        ALDateTimeField thisYear = new ALDateTimeField("yyyy\u5e74");
        today.setValue(new Date());
        thisYear.setValue(new Date());
        if (this.updateDate.toString().equals(today.toString()) && this.updateYear.toString().equals(thisYear.toString())) {
            return this.updateDateTime;
        }
        if (!this.updateDate.toString().equals(today.toString()) && this.updateYear.toString().equals(thisYear.toString())) {
            return this.updateDate;
        }
        return this.updateDateYear;
    }

    public void setDisplayName(String displayName) {
        this.displayName.setValue(displayName);
    }

    public ALStringField getDisplayName() {
        return this.displayName;
    }

    public ALStringField getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId.setValue(externalId);
    }

    public ALStringField getPortletParams() {
        return this.portletParams;
    }

    public void setPortletParams(String portletParams) {
        this.portletParams.setValue(portletParams);
    }

    public String getTitleText() {
        return ALCommonUtils.replaceToAutoCR(this.title.toString());
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId.setValue(moduleId.intValue());
    }

    public ALNumberField getModuleId() {
        return this.moduleId;
    }

    public String getPopupUrl() {
        String portletParams = this.portletParams.getValue();
        String externalId = this.externalId.getValue();
        Long moduleId = this.moduleId.getValue();
        if (portletParams != null && portletParams.length() > 0) {
            StringBuilder b = new StringBuilder(portletParams);
            if (portletParams.indexOf("?") > -1) {
                b.append("&activityId=").append(this.id);
            } else {
                b.append("?activityId=").append(this.id);
            }
            return b.toString();
        }
        try {
            StringBuilder b = new StringBuilder("?template=GadgetsPopupScreen&view=popup&aid=").append(URLEncoder.encode(this.appId.getValue(), "utf-8")).append("&activityId=").append(this.id);
            if (externalId != null && externalId.length() > 0) {
                b.append("&eid=").append(URLEncoder.encode(externalId, "utf-8"));
            }
            if (moduleId != null) {
                b.append("&mid=").append(moduleId);
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setIcon(String icon) {
        this.icon.setValue(icon);
    }

    public ALStringField getIcon() {
        return this.icon;
    }

    public static ALActivity getRecentActivity(String appid, int external_id, float priority) {
        ResultList<ALActivity> list = ALActivityService.getList(new ALActivityGetRequest().withAppId(appid).withLimit(1).withPriority(priority).withExternalId(external_id));
        return list.size() > 0 ? list.get(0) : null;
    }

    public boolean isReplace(String loginname) {
        return loginname.equals(this.getLoginName().getValue());
    }

    public void delete() {
        String sql = "delete from activity where id = " + this.getId();
        Database.sql(Activity.class, sql).execute();
    }
}

