/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.util.CustomizeUtils;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public abstract class ALVelocityScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALVelocityScreen.class.getName());
    private static final String CONTENT_TYPE = "text/html;charset=" + ALEipConstants.DEF_CONTENT_ENCODING;
    private String mode;
    private Object result;
    private List<Object> resultList;
    private List<String> msgList;
    private List<String> errmsgList;

    protected void setTemplate(RunData rundata, Context context, String template) {
        try {
            ServletOutputStream out = null;
            HttpServletResponse response = rundata.getResponse();
            out = response.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
            Template templete = Velocity.getTemplate((String)template);
            templete.merge(context, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"ALVelocityScreen.setTemplate", (Throwable)e);
        }
    }

    protected void doOutput(RunData rundata) throws Exception {
        VelocityContext context = new VelocityContext();
        this.mode = rundata.getParameters().getString("mode");
        try {
            ALEipUtils.setupContext(rundata, (Context)context);
            String portletName = this.getPortletName();
            if (portletName == null || "".equals(portletName) || ALPortalApplicationService.isActive(portletName) && CustomizeUtils.isAdminUserView(portletName, rundata)) {
                this.doOutput(rundata, (Context)context);
            } else {
                context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
                this.setTemplate(rundata, (Context)context, "screens/html/Inactive.vm");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALVelocityScreen.doOutput", (Throwable)ex);
            ALEipUtils.redirectDBError(rundata);
        }
    }

    protected abstract void doOutput(RunData var1, Context var2) throws Exception;

    @Override
    public void setResultData(Object obj) {
        this.result = obj;
    }

    @Override
    public void addResultData(Object obj) {
        if (this.resultList == null) {
            this.resultList = new ArrayList<Object>();
        }
        this.resultList.add(obj);
    }

    @Override
    public void setResultDataList(List<Object> objList) {
        this.resultList = objList;
    }

    @Override
    public void addErrorMessage(String msg) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList<String>();
        }
        this.errmsgList.add(msg);
    }

    @Override
    public void addErrorMessages(List<String> msgs) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList<String>();
        }
        this.errmsgList.addAll(msgs);
    }

    @Override
    public void setErrorMessages(List<String> msgs) {
        this.errmsgList = msgs;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void putData(RunData rundata, Context context) {
        context.put("mode", (Object)this.mode);
        context.put("result", this.result);
        context.put("results", this.resultList);
        context.put("msgs", this.msgList);
        context.put("errmsgs", this.errmsgList);
        context.put("entityid", (Object)ALEipUtils.getTemp(rundata, context, "entityid"));
        context.put("config", (Object)new JetspeedResources());
        context.put("utils", (Object)new ALCommonUtils());
        context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
        context.put("secid", rundata.getUser().getTemp("secid"));
        ALOrgUtilsService.assignCommonContext(context);
        if (Boolean.parseBoolean((String)rundata.getSession().getAttribute("changeToPc"))) {
            context.put("client", (Object)ALEipUtils.getClient(rundata));
        }
    }

    protected String getContentType(RunData rundata) {
        return CONTENT_TYPE;
    }

    protected abstract String getPortletName();
}

