/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.portal.controls;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.portal.controls.ALVelocityPortletControl;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ALVelocityPortletSetControl
extends ALVelocityPortletControl {
    private static final long serialVersionUID = 1054029676869610792L;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALVelocityPortletSetControl.class.getName());

    @Override
    public void buildContext(RunData rundata, Context context) {
        ALOrgUtilsService.assignCommonContext(context);
        if (Boolean.parseBoolean((String)rundata.getSession().getAttribute("changeToPc"))) {
            context.put("client", (Object)ALEipUtils.getClient(rundata));
        }
        if (this.getPortlet() instanceof PortletSet) {
            PortletSet set = (PortletSet)this.getPortlet();
            Collection<PortletTab> tabs = this.getTabs(set, rundata, context);
            Iterator<PortletTab> i = tabs.iterator();
            while (i.hasNext()) {
                PortletTab tab = i.next();
                if (tab.getTitle().toString().equals("\u500b\u4eba\u8a2d\u5b9a")) {
                    i.remove();
                }
                if (!tab.getTitle().toString().equals("\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406")) continue;
                i.remove();
            }
            context.put("tabs", tabs);
            String mypageId = "";
            Enumeration en = set.getPortlets();
            while (en.hasMoreElements()) {
                Portlet p = (Portlet)en.nextElement();
                if (!"\u30de\u30a4\u30da\u30fc\u30b8".equals(p.getTitle())) continue;
                mypageId = p.getID();
            }
            context.put("mypageId", (Object)mypageId);
            context.put("globalPortlets", ALEipUtils.getGlobalPortlets(rundata));
        }
    }

    private Collection<PortletTab> getTabs(PortletSet portlets, RunData rundata, Context context) {
        String peid;
        TreeSet<PortletTab> tabs = new TreeSet<PortletTab>(new PortletTabComparator());
        PanedPortletController controller = null;
        if (portlets.getController() instanceof PanedPortletController) {
            controller = (PanedPortletController)portlets.getController();
        }
        boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, 1);
        context.put("secid", rundata.getUser().getTemp("secid"));
        String portletId = portlets.getID();
        if (controller != null && portletId.equals(peid = rundata.getParameters().getString(controller.getPaneParameter()))) {
            SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(portletId);
            state.setAttribute("js_pane", null);
        }
        Enumeration en = portlets.getPortlets();
        while (en.hasMoreElements()) {
            String mstate;
            JetspeedRunData jdata;
            boolean hasView;
            Portlet p = (Portlet)en.nextElement();
            PortalResource portalResource = new PortalResource(p);
            if (("Activity".equals(p.getName()) || "Message".equals(p.getName())) && !portlets.getController().getConfig().getName().equals("MenuController")) continue;
            JetspeedLink jsLink = null;
            try {
                jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                portalResource.setOwner(jsLink.getUserName());
                JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
            }
            catch (Exception e) {
                logger.warn((Object)"[ALVelocityPortletSetControl]", (Throwable)e);
                portalResource.setOwner(null);
            }
            if (!(hasView = JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)(jdata = (JetspeedRunData)rundata).getUser()), (PortalResource)portalResource, (String)"view")) || p instanceof PortletState && ((PortletState)p).isClosed(rundata) || (mstate = p.getAttribute("_menustate", "open", rundata)).equals("closed")) continue;
            PortletTab tab = new PortletTab();
            tab.setId(p.getID());
            String title = null;
            PortletInstance pi = PersistenceManager.getInstance((Portlet)p, (RunData)rundata);
            if (pi != null && (title = pi.getTitle()) == null) {
                title = p.getTitle() != null ? p.getTitle() : p.getName();
            }
            tab.setTitle(title);
            tab.setPosition(p.getPortletConfig().getPosition());
            if (tabs.contains(tab)) {
                PortletTab lastTab = tabs.last();
                int nextPos = lastTab.getPosition() + 1;
                tab.setPosition(nextPos);
            }
            if (controller != null) {
                tab.setSelected(controller.isSelected(p, rundata));
                if ("IPHONE".equals(ALEipUtils.getClient(rundata))) {
                    tab.setLink(jsLink.getPortletById(p.getID()).addQueryData("action", "controls.Maximize").toString());
                } else {
                    tab.setLink(controller.getPortletURI(p, rundata).toString() + "?action=controls.Restore");
                }
            }
            tab.setActions(this.buildActionList(rundata, p, context));
            tab.setAuthority(hasAuthority);
            tabs.add(tab);
        }
        return tabs;
    }

    public static class PortletTabComparator
    implements Comparator<PortletTab>,
    Serializable {
        @Override
        public int compare(PortletTab o1, PortletTab o2) {
            try {
                PortletTab pt1 = o1;
                PortletTab pt2 = o2;
                int pos1 = pt1.getPosition();
                int pos2 = pt2.getPosition();
                if (pos1 < pos2) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                return 0;
            }
            catch (ClassCastException e) {
                logger.error((Object)"ALVelocityPortletSetControl.compare", (Throwable)e);
                return 0;
            }
        }
    }

    public static class PortletTab {
        private String id = null;
        private final ALStringField title = new ALStringField();
        private boolean selected = false;
        private String link = null;
        private List<ALVelocityPortletControl.PortletAction> actions = null;
        private int position = -1;
        private boolean authority = true;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public ALStringField getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title.setValue(title);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public List<ALVelocityPortletControl.PortletAction> getActions() {
            return this.actions == null ? new Vector() : this.actions;
        }

        public void setActions(List<ALVelocityPortletControl.PortletAction> actions) {
            this.actions = actions;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int pos) {
            this.position = pos;
        }

        public boolean getAuthority() {
            return this.authority;
        }

        public void setAuthority(boolean flg) {
            this.authority = flg;
        }
    }
}

