/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineRole;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.GroupException;
import org.apache.jetspeed.services.security.GroupManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class ALGroupManagement
extends TurbineBaseService
implements GroupManagement {
    private JetspeedRunDataService runDataService = null;
    private static final String CONFIG_DEFAULT_ROLE = "role.default";
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private boolean cascadeDelete;
    protected String defaultRole = "user";

    public void addGroup(Group group) throws JetspeedSecurityException {
        if (this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' already exists");
        }
        try {
            Database.commit();
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", (Throwable)e);
        }
        try {
            this.addDefaultGroupPSML(group);
        }
        catch (Exception e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("failed to add default PSML for Group resource", (Throwable)e);
        }
    }

    public Iterator<Group> getGroups(String username) throws JetspeedSecurityException {
        HashMap<String, Object> groups;
        JetspeedUser user = null;
        try {
            user = JetspeedSecurity.getUser((Principal)new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)e);
        }
        Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)user.getUserId());
        SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class, exp);
        try {
            List<TurbineUserGroupRole> rels = query.fetchList();
            groups = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, TurbineGroup>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineUserGroupRole rel = rels.get(ix);
                TurbineGroup group = rel.getTurbineGroup();
                groups.put(group.getName(), group);
            }
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", (Throwable)e);
        }
        return groups.values().iterator();
    }

    public Iterator<TurbineGroup> getGroups() throws JetspeedSecurityException {
        List<TurbineGroup> groups;
        try {
            SelectQuery<TurbineGroup> query = Database.query(TurbineGroup.class);
            groups = query.fetchList();
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", (Throwable)e);
        }
        return groups.iterator();
    }

    protected void addDefaultGroupPSML(Group group) throws GroupException {
        try {
            String orgId = Database.getDomainName();
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setGroup(group);
            profile.setMediaType("html");
            profile.setOrgName(orgId);
            Profiler.createProfile((RunData)rundata, (Profile)profile);
        }
        catch (ProfileException e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("Failed to create Group PSML", (Throwable)e);
        }
    }

    public void saveGroup(Group group) throws JetspeedSecurityException {
        if (!this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' doesn't exists");
        }
        try {
            if (!(group instanceof TurbineGroup)) {
                throw new GroupException("TurbineGroupManagment: Group is not a Turbine group, cannot update");
            }
            Database.commit();
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", (Throwable)e);
        }
    }

    public void removeGroup(String groupname) throws JetspeedSecurityException {
        try {
            Group group = this.getGroup(groupname);
            if (this.cascadeDelete) {
                Expression exp = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(group.getId()));
                SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class, exp);
                query.deleteAll();
            }
            Database.delete((Persistent)((TurbineGroup)group));
            PsmlManager.removeGroupDocuments((Group)group);
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            throw new GroupException("Failed to remove group '" + groupname + "'", (Throwable)e);
        }
    }

    public void joinGroup(String username, String groupname) throws JetspeedSecurityException {
        this.joinGroup(username, groupname, this.defaultRole);
    }

    public void joinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            Group group = this.getGroup(groupname);
            Role role = JetspeedSecurity.getRole((String)rolename);
            TurbineUserGroupRole user_group_role = Database.create(TurbineUserGroupRole.class);
            TurbineUser tuser = ALEipUtils.getTurbineUser(Integer.valueOf(user.getUserId()));
            user_group_role.setTurbineUser(tuser);
            user_group_role.setTurbineGroup((TurbineGroup)group);
            user_group_role.setTurbineRole((TurbineRole)role);
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            throw new GroupException("Join group '" + groupname + "' to user '" + username + "' failed: ", (Throwable)e);
        }
    }

    public void unjoinGroup(String username, String groupname) throws JetspeedSecurityException {
        this.unjoinGroup(username, groupname, this.defaultRole);
    }

    public void unjoinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            Group group = this.getGroup(groupname);
            Role role = JetspeedSecurity.getRole((String)rolename);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(user.getUserId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(group.getId()));
            Expression exp3 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            query.andQualifier(exp3);
            query.deleteAll();
            Database.commit();
        }
        catch (Exception e) {
            throw new GroupException("Unjoin group '" + groupname + "' to user '" + username + "' failed: ", (Throwable)e);
        }
    }

    public boolean inGroup(String username, String groupname) throws JetspeedSecurityException {
        List<TurbineUserGroupRole> groups;
        try {
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            Group group = this.getGroup(groupname);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)user.getUserId());
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)group.getId());
            SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            groups = query.fetchList();
        }
        catch (Exception e) {
            throw new GroupException("Failed to check group '" + groupname + "'", (Throwable)e);
        }
        return groups.size() > 0;
    }

    public Group getGroup(String groupname) throws JetspeedSecurityException {
        List<TurbineGroup> groups;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)groupname);
            SelectQuery<TurbineGroup> query = Database.query(TurbineGroup.class, exp);
            groups = query.fetchList();
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve group '" + groupname + "'", (Throwable)e);
        }
        if (groups.size() > 1) {
            throw new GroupException("Multiple Groups with same groupname '" + groupname + "'");
        }
        if (groups.size() == 1) {
            TurbineGroup group = groups.get(0);
            return group;
        }
        throw new GroupException("Unknown group '" + groupname + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean groupExists(String groupName) throws GroupException {
        List<TurbineGroup> groups;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)groupName);
            groups = Database.query(TurbineGroup.class, exp).fetchList();
        }
        catch (Exception e) {
            throw new GroupException("Failed to check account's presence", (Throwable)e);
        }
        return groups.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.defaultRole = serviceConf.getString(CONFIG_DEFAULT_ROLE, this.defaultRole);
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.setInit(true);
    }
}

