/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineRole;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletConfig;
import org.apache.cayenne.Persistent;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.BaseJetspeedUser;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CredentialsManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.NotUniqueUserException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.services.security.UserException;
import org.apache.jetspeed.services.security.UserManagement;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class ALUserManagement
extends TurbineBaseService
implements UserManagement,
CredentialsManagement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALUserManagement.class.getName());
    private static final String CONFIG_SECURE_PASSWORDS_KEY = "secure.passwords";
    private static final String CONFIG_SECURE_PASSWORDS_ALGORITHM = "secure.passwords.algorithm";
    private static final String CONFIG_SYSTEM_USERS = "system.users";
    boolean securePasswords = false;
    String passwordsAlgorithm = "SHA";
    Vector<?> systemUsers = null;
    private static final String CONFIG_NEWUSER_ROLES = "newuser.roles";
    private static final String CONFIG_NEW_ADMINUSER_ROLES = "newadminuser.roles";
    private static final String[] DEFAULT_CONFIG_NEWUSER_ROLES = new String[]{"user"};
    private static final String[] DEFAULT_CONFIG_NEW_ADMINUSER_ROLES = new String[]{"user", "admin"};
    String[] roles = null;
    String[] admin_roles = null;
    private JetspeedRunDataService runDataService = null;

    protected JetspeedUser row2UserObject(TurbineUser tuser) throws UserException {
        try {
            JetspeedUser user = JetspeedUserFactory.getInstance((boolean)false);
            ALBaseUser baseuser = (ALBaseUser)user;
            baseuser.setUserId(tuser.getUserId().toString());
            baseuser.setUserName(tuser.getLoginName());
            baseuser.setPassword(tuser.getPasswordValue());
            baseuser.setFirstName(tuser.getFirstName());
            baseuser.setLastName(tuser.getLastName());
            baseuser.setEmail(tuser.getEmail());
            baseuser.setConfirmed(tuser.getConfirmValue());
            baseuser.setModified(tuser.getModified());
            baseuser.setCreated(tuser.getCreated());
            baseuser.setLastLogin(tuser.getLastLogin());
            baseuser.setDisabled(tuser.getDisabled());
            baseuser.setPasswordChanged(tuser.getPasswordChanged());
            baseuser.setCompanyId(tuser.getCompanyId() != null ? tuser.getCompanyId() : 0);
            baseuser.setPositionId(tuser.getPositionId() != null ? tuser.getPositionId() : 0);
            baseuser.setInTelephone(tuser.getInTelephone());
            baseuser.setOutTelephone(tuser.getOutTelephone());
            baseuser.setCellularPhone(tuser.getCellularPhone());
            baseuser.setCellularMail(tuser.getCellularMail());
            baseuser.setCelluarUId(tuser.getCellularUid());
            baseuser.setLastNameKana(tuser.getLastNameKana());
            baseuser.setFirstNameKana(tuser.getFirstNameKana());
            baseuser.setPhoto(tuser.getPhoto());
            baseuser.setPhotoSmartphone(tuser.getPhotoSmartphone());
            baseuser.setCreatedUserId(tuser.getCreatedUserId() != null ? tuser.getCreatedUserId() : 0);
            baseuser.setUpdatedUserId(tuser.getUpdatedUserId() != null ? tuser.getUpdatedUserId() : 0);
            baseuser.setPhotoModified(tuser.getPhotoModified());
            baseuser.setPhotoModifiedSmartphone(tuser.getPhotoModifiedSmartphone());
            baseuser.setHasPhoto("T".equals(tuser.getHasPhoto()));
            baseuser.setHasPhotoSmartphone("T".equals(tuser.getHasPhotoSmartphone()));
            baseuser.setMigrateVersion(tuser.getMigrateVersion() != null ? tuser.getMigrateVersion() : 0);
            return baseuser;
        }
        catch (Exception e) {
            logger.error((Object)"ALUserManagement.row2UserObject", (Throwable)e);
            return null;
        }
    }

    public JetspeedUser getUser(Principal principal) throws JetspeedSecurityException {
        TurbineUser user;
        block9: {
            user = null;
            try {
                if (principal instanceof UserNamePrincipal) {
                    user = ALEipUtils.getTurbineUser(principal.getName());
                    break block9;
                }
                if (principal instanceof UserIdPrincipal) {
                    user = ALEipUtils.getTurbineUser(Integer.valueOf(principal.getName()));
                    break block9;
                }
                throw new UserException("Invalid Principal Type in getUser: " + principal.getClass().getName());
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                String message = "Failed to retrieve user '" + principal.getName() + "'";
                logger.error((Object)message, (Throwable)e);
                throw new UserException(message, (Throwable)e);
            }
        }
        try {
            if (null == user) {
                return null;
            }
            JetspeedUser juser = this.row2UserObject(user);
            return juser;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (UserException e) {
            String message = "Failed to retrieve user '" + principal.getName() + "'";
            logger.warn((Object)message, (Throwable)e);
            throw new UserException(message, (Throwable)e);
        }
    }

    public JetspeedUser getUser(RunData rundata, Principal principal) throws JetspeedSecurityException {
        return this.getUser(principal);
    }

    public Iterator<JetspeedUser> getUsers() throws JetspeedSecurityException {
        ArrayList<JetspeedUser> users = new ArrayList<JetspeedUser>();
        try {
            List<TurbineUser> list = Database.query(TurbineUser.class).fetchList();
            for (TurbineUser user : list) {
                users.add(this.row2UserObject(user));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve users ", (Throwable)e);
            throw new UserException("Failed to retrieve users ", (Throwable)e);
        }
        return users.iterator();
    }

    public Iterator<JetspeedUser> getUsers(String filter) throws JetspeedSecurityException {
        ArrayList<JetspeedUser> users = new ArrayList<JetspeedUser>();
        try {
            List<TurbineUser> list = Database.query(TurbineUser.class).fetchList();
            for (TurbineUser user : list) {
                users.add(this.row2UserObject(user));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve users ", (Throwable)e);
            throw new UserException("Failed to retrieve users ", (Throwable)e);
        }
        return users.iterator();
    }

    public void saveUser(JetspeedUser user) throws JetspeedSecurityException {
        if (!this.accountExists(user, true)) {
            throw new UnknownUserException("Cannot save user '" + user.getUserName() + "', User doesn't exist");
        }
        try {
            Boolean hasAdminCredential = (Boolean)user.getPerm("isAdmin", null);
            ALBaseUser baseuser = (ALBaseUser)user;
            TurbineUser tuser = ALEipUtils.getTurbineUser(Integer.valueOf(user.getUserId()));
            if (tuser == null) {
                throw new UnknownUserException("Cannot save user '" + user.getUserName() + "', User doesn't exist");
            }
            tuser.setLoginName(baseuser.getUserName());
            tuser.setPasswordValue(baseuser.getPassword());
            tuser.setFirstName(baseuser.getFirstName());
            tuser.setLastName(baseuser.getLastName());
            tuser.setEmail(baseuser.getEmail());
            tuser.setConfirmValue(baseuser.getConfirmed());
            if (baseuser.isNew()) {
                tuser.setCreated(baseuser.getCreateDate());
                tuser.setModified(baseuser.getCreateDate());
                tuser.setLastLogin(baseuser.getCreateDate());
            } else {
                Date lastLogin = baseuser.getLastLogin();
                Date lastLoginDb = tuser.getLastLogin();
                if (lastLogin != null && lastLoginDb != null && !lastLogin.equals(lastLoginDb)) {
                    tuser.setLastLogin(baseuser.getLastLogin());
                } else {
                    tuser.setModified(new Date());
                }
            }
            tuser.setDisabled(baseuser.getDisabled());
            tuser.setObjectdata(null);
            tuser.setPasswordChanged(baseuser.getPasswordChanged());
            tuser.setCompanyId(Integer.valueOf(baseuser.getCompanyId()));
            tuser.setPositionId(Integer.valueOf(baseuser.getPositionId()));
            tuser.setInTelephone(baseuser.getInTelephone());
            tuser.setOutTelephone(baseuser.getOutTelephone());
            tuser.setCellularPhone(baseuser.getCellularPhone());
            tuser.setCellularMail(baseuser.getCellularMail());
            tuser.setCellularUid(baseuser.getCelluarUId());
            tuser.setLastNameKana(baseuser.getLastNameKana());
            tuser.setFirstNameKana(baseuser.getFirstNameKana());
            tuser.setPhoto(baseuser.getPhoto());
            tuser.setPhotoSmartphone(baseuser.getPhotoSmartphone());
            tuser.setCreatedUserId(Integer.valueOf(baseuser.getCreatedUserId()));
            tuser.setUpdatedUserId(Integer.valueOf(baseuser.getUpdatedUserId()));
            tuser.setHasPhoto(baseuser.hasPhoto() ? "T" : "F");
            tuser.setPhotoModified(baseuser.getPhotoModified());
            tuser.setHasPhotoSmartphone(baseuser.hasPhotoSmartphone() ? "T" : "F");
            tuser.setPhotoModifiedSmartphone(baseuser.getPhotoModifiedSmartphone());
            tuser.setMigrateVersion(Integer.valueOf(baseuser.getMigrateVersion()));
            if (hasAdminCredential != null) {
                if (hasAdminCredential.booleanValue()) {
                    this.setAdminRole(tuser);
                    ALEipUtils.addAdminPage(tuser.getLoginName());
                } else {
                    this.removeAdminRole(tuser);
                    this.removeAdminPage(tuser.getLoginName());
                }
                this.grantRoles(user, hasAdminCredential);
            }
            Database.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Failed to save user object ", (Throwable)e);
            throw new UserException("Failed to save user object ", (Throwable)e);
        }
    }

    public void addUser(JetspeedUser user) throws JetspeedSecurityException {
        List<EipMUserPosition> userposlist;
        if (this.accountExists(user)) {
            throw new NotUniqueUserException("The account '" + user.getUserName() + "' already exists");
        }
        boolean hasAdminCredential = (Boolean)user.getPerm("isAdmin", (Object)false);
        String initialPassword = user.getPassword();
        String encrypted = JetspeedSecurity.encryptPassword((String)initialPassword);
        user.setPassword(encrypted);
        ALBaseUser baseuser = (ALBaseUser)user;
        TurbineUser tuser = Database.create(TurbineUser.class);
        tuser.setLoginName(baseuser.getUserName());
        tuser.setPasswordValue(baseuser.getPassword());
        tuser.setFirstName(baseuser.getFirstName());
        tuser.setLastName(baseuser.getLastName());
        tuser.setEmail(baseuser.getEmail());
        tuser.setConfirmValue(baseuser.getConfirmed());
        tuser.setModified(baseuser.getCreateDate());
        tuser.setCreated(baseuser.getCreateDate());
        tuser.setLastLogin(baseuser.getCreateDate());
        tuser.setDisabled(baseuser.getDisabled());
        tuser.setObjectdata(null);
        tuser.setPasswordChanged(baseuser.getPasswordChanged());
        tuser.setCompanyId(Integer.valueOf(baseuser.getCompanyId()));
        tuser.setPositionId(Integer.valueOf(baseuser.getPositionId()));
        tuser.setInTelephone(baseuser.getInTelephone());
        tuser.setOutTelephone(baseuser.getOutTelephone());
        tuser.setCellularPhone(baseuser.getCellularPhone());
        tuser.setCellularMail(baseuser.getCellularMail());
        tuser.setLastNameKana(baseuser.getLastNameKana());
        tuser.setFirstNameKana(baseuser.getFirstNameKana());
        tuser.setPhoto(baseuser.getPhoto());
        tuser.setPhotoSmartphone(baseuser.getPhotoSmartphone());
        tuser.setCreatedUserId(Integer.valueOf(baseuser.getCreatedUserId()));
        tuser.setUpdatedUserId(Integer.valueOf(baseuser.getUpdatedUserId()));
        tuser.setHasPhoto(baseuser.hasPhoto() ? "T" : "F");
        tuser.setPhotoModified(new Date());
        tuser.setHasPhotoSmartphone(baseuser.hasPhotoSmartphone() ? "T" : "F");
        tuser.setPhotoModifiedSmartphone(baseuser.getPhotoModifiedSmartphone());
        tuser.setMigrateVersion(Integer.valueOf(baseuser.getMigrateVersion()));
        Group group = JetspeedSecurity.getGroup((String)"LoginUser");
        Role role = JetspeedSecurity.getRole((String)"user");
        TurbineUserGroupRole user_group_role = Database.create(TurbineUserGroupRole.class);
        user_group_role.setTurbineUser(tuser);
        user_group_role.setTurbineGroup((TurbineGroup)group);
        user_group_role.setTurbineRole((TurbineRole)role);
        if (hasAdminCredential) {
            this.setAdminRole(tuser);
        }
        int new_pos = (userposlist = Database.query(EipMUserPosition.class).fetchList()) != null && userposlist.size() > 0 ? userposlist.size() + 1 : 1;
        EipMUserPosition userposition = Database.create(EipMUserPosition.class);
        userposition.setTurbineUser(tuser);
        userposition.setPosition(Integer.valueOf(new_pos));
        try {
            Database.commit();
            ((BaseJetspeedUser)user).setUserId(tuser.getUserId().toString());
        }
        catch (Exception e) {
            Database.rollback();
            String message = "Failed to create account '" + user.getUserName() + "'";
            logger.error((Object)message, (Throwable)e);
            throw new UserException(message, (Throwable)e);
        }
        this.addDefaultPSML(user, hasAdminCredential);
    }

    private void addDefaultPSML(JetspeedUser user, boolean hasAdminCredential) throws JetspeedSecurityException {
        String orgId = Database.getDomainName();
        this.grantRoles(user, hasAdminCredential);
        try {
            JetspeedRunData rundata = this.getRunData();
            if (rundata != null && !Profiler.useRoleProfileMerging()) {
                Profile profile = Profiler.createProfile();
                profile.setUser(user);
                profile.setMediaType("html");
                profile.setOrgName(orgId);
                Profiler.createProfile((RunData)this.getRunData(), (Profile)profile);
                if (hasAdminCredential) {
                    this.addAdminPage((User)user);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create profile for new user ", (Throwable)e);
            this.removeUser((Principal)new UserNamePrincipal(user.getUserName()));
            throw new UserException("Failed to create profile for new user ", (Throwable)e);
        }
    }

    private void grantRoles(JetspeedUser user, boolean hasAdminCredential) {
        String[] _roles = null;
        _roles = hasAdminCredential ? this.admin_roles : this.roles;
        for (int i = 0; i < _roles.length; ++i) {
            try {
                JetspeedSecurity.grantRole((String)user.getUserName(), (String)JetspeedSecurity.getRole((String)_roles[i]).getName());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Could not grant role: " + _roles[i] + " to user " + user.getUserName()), (Throwable)e);
            }
        }
    }

    private void addAdminPage(User user) throws Exception {
        ALEipUtils.addAdminPage(user.getUserName());
    }

    private void removeAdminPage(String user_name) throws Exception {
        ProfileLocator locator = Profiler.createLocator();
        locator.createFromPath(String.format("user/%s/media-type/html", user_name));
        Profile profile = Profiler.getProfile((ProfileLocator)locator);
        Portlets portlets = profile.getDocument().getPortlets();
        ArrayList<Integer> remove_index = new ArrayList<Integer>();
        if (portlets != null) {
            int portlet_size = portlets.getPortletsCount();
            for (int i = 0; i < portlet_size; ++i) {
                Portlets p = portlets.getPortlets(i);
                if (!p.getSecurityRef().getParent().equals("admin-view")) continue;
                remove_index.add(i);
            }
            Collections.reverse(remove_index);
            for (Integer index : remove_index) {
                portlets.removePortlets(index.intValue());
            }
        }
        PsmlManager.store((Profile)profile);
    }

    private void setAdminRole(TurbineUser tuser) throws JetspeedSecurityException {
        Role adminrole = JetspeedSecurity.getRole((String)"admin");
        Group group = JetspeedSecurity.getGroup((String)"LoginUser");
        TurbineUserGroupRole admin_group_role = Database.create(TurbineUserGroupRole.class);
        admin_group_role.setTurbineUser(tuser);
        admin_group_role.setTurbineGroup((TurbineGroup)group);
        admin_group_role.setTurbineRole((TurbineRole)adminrole);
    }

    private void removeAdminRole(TurbineUser tuser) throws JetspeedSecurityException {
        String admin_role_id = JetspeedSecurity.getRole((String)"admin").getId();
        List user_roles = tuser.getTurbineUserGroupRole();
        for (TurbineUserGroupRole role : user_roles) {
            if (!role.getTurbineRole().getId().equals(admin_role_id)) continue;
            Database.delete((Persistent)role);
        }
        Database.commit();
    }

    public void removeUser(Principal principal) throws JetspeedSecurityException {
        if (this.systemUsers.contains(principal.getName())) {
            throw new UserException("[" + principal.getName() + "] is a system user and cannot be removed");
        }
        JetspeedUser user = this.getUser(principal);
        try {
            TurbineUser tuser = ALEipUtils.getTurbineUser(Integer.valueOf(user.getUserId()));
            if (tuser == null) {
                throw new UserException("[" + principal.getName() + "] is a system user and cannot be removed");
            }
            Database.delete((Persistent)tuser);
            PsmlManager.removeUserDocuments((JetspeedUser)user);
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            String message = "Failed to remove account '" + user.getUserName() + "'";
            logger.error((Object)message, (Throwable)e);
            throw new UserException(message, (Throwable)e);
        }
    }

    public void changePassword(JetspeedUser user, String oldPassword, String newPassword) throws JetspeedSecurityException {
        oldPassword = JetspeedSecurity.convertPassword((String)oldPassword);
        newPassword = JetspeedSecurity.convertPassword((String)newPassword);
        String encrypted = JetspeedSecurity.encryptPassword((String)oldPassword);
        if (!this.accountExists(user)) {
            throw new UnknownUserException(Localization.getString((String)"UPDATEACCOUNT_NOUSER"));
        }
        if (!user.getPassword().equals(encrypted)) {
            throw new UserException(Localization.getString((String)"UPDATEACCOUNT_BADOLDPASSWORD"));
        }
        user.setPassword(JetspeedSecurity.encryptPassword((String)newPassword));
        user.setPasswordChanged(new Date());
        this.saveUser(user);
    }

    public void forcePassword(JetspeedUser user, String password) throws JetspeedSecurityException {
        if (!this.accountExists(user)) {
            throw new UnknownUserException("The account '" + user.getUserName() + "' does not exist");
        }
        user.setPassword(JetspeedSecurity.encryptPassword((String)password));
        this.saveUser(user);
    }

    public String encryptPassword(String password) throws JetspeedSecurityException {
        if (!this.securePasswords) {
            return password;
        }
        if (password == null) {
            return null;
        }
        try {
            if ("SHA-512".equals(this.passwordsAlgorithm)) {
                password = password + JetspeedResources.getString((String)"aipo.encrypt_key");
                MessageDigest md = MessageDigest.getInstance(this.passwordsAlgorithm);
                md.reset();
                md.update(password.getBytes());
                byte[] hash = md.digest();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < hash.length; ++i) {
                    sb.append(Integer.toHexString(hash[i] >> 4 & 0xF));
                    sb.append(Integer.toHexString(hash[i] & 0xF));
                }
                return sb.toString();
            }
            MessageDigest md = MessageDigest.getInstance(this.passwordsAlgorithm);
            byte[] digest = md.digest(password.getBytes(ALEipConstants.DEF_CONTENT_ENCODING));
            ByteArrayOutputStream bas = new ByteArrayOutputStream(digest.length + digest.length / 3 + 1);
            OutputStream encodedStream = MimeUtility.encode((OutputStream)bas, (String)"base64");
            encodedStream.write(digest);
            encodedStream.flush();
            encodedStream.close();
            return bas.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to encrypt password." + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.securePasswords = serviceConf.getBoolean(CONFIG_SECURE_PASSWORDS_KEY, this.securePasswords);
        this.passwordsAlgorithm = serviceConf.getString(CONFIG_SECURE_PASSWORDS_ALGORITHM, this.passwordsAlgorithm);
        this.systemUsers = serviceConf.getVector(CONFIG_SYSTEM_USERS, new Vector());
        try {
            this.roles = serviceConf.getStringArray(CONFIG_NEWUSER_ROLES);
            this.admin_roles = serviceConf.getStringArray(CONFIG_NEW_ADMINUSER_ROLES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.roles || this.roles.length == 0) {
            this.roles = DEFAULT_CONFIG_NEWUSER_ROLES;
        }
        if (null == this.admin_roles || this.admin_roles.length == 0) {
            this.admin_roles = DEFAULT_CONFIG_NEW_ADMINUSER_ROLES;
        }
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    protected boolean accountExists(JetspeedUser user) throws UserException {
        return this.accountExists(user, false);
    }

    protected boolean accountExists(JetspeedUser user, boolean checkUniqueId) throws UserException {
        String id = user.getUserId();
        TurbineUser retrieved = null;
        try {
            retrieved = ALEipUtils.getTurbineUser(user.getUserName());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to check account's presence", (Throwable)e);
            throw new UserException("Failed to check account's presence", (Throwable)e);
        }
        if (retrieved == null) {
            return false;
        }
        String keyId = retrieved.getUserId().toString();
        if (checkUniqueId && !keyId.equals(id)) {
            throw new UserException("User exists but under a different unique ID");
        }
        return true;
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }
}

