/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.social;

import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.social.ALSocialApplicationFactoryService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.services.social.gadgets.ALGadgetSpec;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.services.social.model.ALApplicationPutRequest;
import java.util.List;
import java.util.Map;

public class ALApplicationService {
    private ALApplicationService() {
    }

    public static ALSocialApplicationHandler getService() {
        return ALSocialApplicationFactoryService.getInstance().getSocialApplicationHandler();
    }

    public static ResultList<ALApplication> getList(ALApplicationGetRequest request) {
        return ALApplicationService.getService().getApplicationList(request);
    }

    public static ALApplication get(ALApplicationGetRequest request) {
        return ALApplicationService.getService().getApplication(request);
    }

    public static void create(ALApplicationPutRequest request) {
        ALApplicationService.getService().createApplication(request);
    }

    public static void update(String appId, ALApplicationPutRequest request) {
        ALApplicationService.getService().updateApplication(appId, request);
    }

    public static void delete(String ... appIdList) {
        ALApplicationService.getService().deleteApplication(appIdList);
    }

    public static void delete(List<String> appIdList) {
        ALApplicationService.getService().deleteApplication(appIdList);
    }

    public static void enable(String ... appIdList) {
        ALApplicationService.getService().enableApplication(appIdList);
    }

    public static void enable(List<String> appIdList) {
        ALApplicationService.getService().enableApplication(appIdList);
    }

    public static void disable(String ... appIdList) {
        ALApplicationService.getService().disableApplication(appIdList);
    }

    public static void disable(List<String> appIdList) {
        ALApplicationService.getService().disableApplication(appIdList);
    }

    public static boolean checkAvailability(String appId) {
        return ALApplicationService.getService().checkApplicationAvailability(appId);
    }

    public static ALGadgetSpec getMetaData(String specUrl) {
        return ALApplicationService.getService().getMetaData(specUrl);
    }

    public static Map<String, ALGadgetSpec> getMetaData(List<String> specUrls, String view, boolean isDetail, boolean nochache) {
        return ALApplicationService.getService().getMetaData(specUrls, view, isDetail, nochache);
    }

    public static Map<String, ALGadgetSpec> getMetaData(List<String> specUrls) {
        return ALApplicationService.getService().getMetaData(specUrls, null, false, true);
    }

    public static ALGadgetSpec getMetaData(String specUrl, boolean isDetail) {
        return ALApplicationService.getService().getMetaData(specUrl, isDetail);
    }

    public static long getNextModuleId() {
        return ALApplicationService.getService().getNextModuleId();
    }

    public static void deleteUserData(String ... loginNameList) {
        ALApplicationService.getService().deleteUserData(loginNameList);
    }

    public static void deleteUserData(List<String> loginNameList) {
        ALApplicationService.getService().deleteUserData(loginNameList);
    }
}

