/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineFile;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;

public class ALTimelineUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALTimelineUtils.class.getName());

    public static boolean hasTimelinePost() {
        return Database.query(EipTTimeline.class).getCount() > 0;
    }

    public static void postTimeline(JetspeedRunData data, int uid) {
        Date now = new Date();
        EipTTimeline timeline = Database.create(EipTTimeline.class);
        timeline.setParentId(Integer.valueOf(0));
        timeline.setOwnerId(Integer.valueOf(uid));
        timeline.setExternalId(null);
        timeline.setNote(ALLocalizationUtils.getl10n("TIMELINE_GUIDE_MESSAGE"));
        timeline.setTimelineType("T");
        timeline.setParams(null);
        timeline.setCreateDate(now);
        timeline.setUpdateDate(now);
        Database.commit();
        try {
            ALTimelineUtils.uploadTimelineImage(data.getServletContext(), uid, 0, ALLocalizationUtils.getl10n("TIMELINE_GUIDE_IMAGE_1"), "/images/first/guide01.png", "/images/first/guide01s.jpg", timeline);
            ALTimelineUtils.uploadTimelineImage(data.getServletContext(), uid, 1, ALLocalizationUtils.getl10n("TIMELINE_GUIDE_IMAGE_2"), "/images/first/guide02.png", "/images/first/guide02s.jpg", timeline);
            ALTimelineUtils.uploadTimelineImage(data.getServletContext(), uid, 2, ALLocalizationUtils.getl10n("TIMELINE_GUIDE_IMAGE_3"), "/images/first/guide03.png", "/images/first/guide03s.jpg", timeline);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"ALTimelineUtils", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"ALTimelineUtils", (Throwable)e);
        }
    }

    private static void uploadTimelineImage(ServletContext servletContext, int uid, int index, String title, String filePath, String sFilePath, EipTTimeline timeline) throws FileNotFoundException, IOException {
        Date now = new Date();
        String filename = index + "_" + String.valueOf(System.nanoTime());
        File tmpFile = new File(servletContext.getRealPath(sFilePath));
        byte[] imageInBytes = IOUtils.toByteArray((InputStream)new FileInputStream(tmpFile));
        EipTTimelineFile file = Database.create(EipTTimelineFile.class);
        file.setOwnerId(Integer.valueOf(uid));
        file.setFileName(title);
        file.setFilePath(ALTimelineUtils.getRelativePath(filename));
        file.setFileThumbnail(imageInBytes);
        file.setEipTTimeline(timeline);
        file.setCreateDate(now);
        file.setUpdateDate(now);
        Database.commit();
        tmpFile = new File(servletContext.getRealPath(filePath));
        imageInBytes = IOUtils.toByteArray((InputStream)new FileInputStream(tmpFile));
        ALStorageService.createNewFile(new ByteArrayInputStream(imageInBytes), JetspeedResources.getString((String)"aipo.filedir", (String)"") + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + JetspeedResources.getString((String)"aipo.timeline.categorykey", (String)"") + ALStorageService.separator() + uid + ALStorageService.separator() + filename);
    }

    private static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }
}

