/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.cayenne.access.CustomDataSourceUtil;
import org.apache.cayenne.conf.CustomDBCPDataSourceBuilder;
import org.apache.cayenne.conf.DBCPDataSourceFactory;
import org.apache.cayenne.conf.DBCPDataSourceProperties;
import org.apache.cayenne.conf.DataSourceFactoryDelegate;
import org.apache.commons.dbcp.ThreadPoolingDataSource;
import org.apache.commons.pool.ObjectPool;

public class CustomDBCPDataSourceFactory
extends DBCPDataSourceFactory
implements DataSourceFactoryDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(String location) throws Exception {
        DBCPDataSourceProperties properties = null;
        if (System.getProperty("catalina.home") != null) {
            String baseLocation = System.getProperty("catalina.home") + File.separator + location;
            FileInputStream in = null;
            try {
                in = new FileInputStream(baseLocation);
                Properties p = new Properties();
                p.load(in);
                properties = new DBCPDataSourceProperties(p);
            }
            catch (Throwable ignore) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
        if (properties == null) {
            properties = new DBCPDataSourceProperties(this.parentConfiguration.getResourceLocator(), location);
        }
        CustomDBCPDataSourceBuilder builder = new CustomDBCPDataSourceBuilder(properties);
        return builder.createDataSource();
    }

    @Override
    public void tearDown() {
        try {
            ObjectPool pool;
            ThreadPoolingDataSource poolingDataSource;
            DataSource dataSource = CustomDataSourceUtil.getThreadDataSource();
            if (dataSource instanceof ThreadPoolingDataSource && (poolingDataSource = (ThreadPoolingDataSource)dataSource) != null && (pool = poolingDataSource.getPool()) != null) {
                try {
                    pool.close();
                }
                catch (Throwable t) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

