/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

class CorrectedContentTypeDataSource
implements DataSource,
MessageAware {
    protected DataSource source;
    protected String charset;

    public CorrectedContentTypeDataSource() {
    }

    public CorrectedContentTypeDataSource(DataSource dataSource, String string) {
        this.setDataSource(dataSource);
        this.setDefaultCharset(string);
    }

    public CorrectedContentTypeDataSource(Part part, String string) throws MessagingException {
        this.setPart(part);
        this.setDefaultCharset(string);
    }

    public void setPart(Part part) throws MessagingException {
        this.setDataSource(part.getDataHandler().getDataSource());
    }

    public void setDataSource(DataSource dataSource) {
        this.source = dataSource;
    }

    public void setDefaultCharset(String string) {
        this.charset = string;
    }

    public String getContentType() {
        ContentType contentType = null;
        try {
            contentType = new ContentType(this.source.getContentType());
        }
        catch (ParseException parseException) {
            return "text/plain; charset=" + this.charset;
        }
        String string = contentType.getParameter("charset");
        if (string == null) {
            contentType.setParameter("charset", this.charset);
        }
        return contentType.toString();
    }

    public String getName() {
        return this.source.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.source.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.source.getOutputStream();
    }

    public synchronized MessageContext getMessageContext() {
        if (this.source instanceof MessageAware) {
            return ((MessageAware)this.source).getMessageContext();
        }
        throw new RuntimeException(this.source + " isn't MessageAware.");
    }
}

