/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config.generator.model.elements;

import java.util.List;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.generator.model.NodeElement;
import net.sf.ehcache.config.generator.model.SimpleNodeAttribute;
import net.sf.ehcache.config.generator.model.SimpleNodeElement;
import net.sf.ehcache.config.generator.model.elements.CacheConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.DefaultCacheConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.DiskStoreConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.FactoryConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.TerracottaConfigConfigurationElement;

public class ConfigurationElement
extends SimpleNodeElement {
    private final Configuration configuration;

    public ConfigurationElement(Configuration configuration) {
        super(null, "ehcache");
        this.configuration = configuration;
        this.init();
    }

    private void init() {
        List<FactoryConfiguration> cacheManagerPeerListenerFactoryConfigurations;
        List<FactoryConfiguration> cacheManagerPeerProviderFactoryConfiguration;
        FactoryConfiguration cacheManagerEventListenerFactoryConfiguration;
        FactoryConfiguration transactionManagerLookupConfiguration;
        if (this.configuration == null) {
            return;
        }
        this.addAttribute(new SimpleNodeAttribute("name", this.configuration.getName()).optional(true));
        this.addAttribute(new SimpleNodeAttribute("updateCheck", this.configuration.getUpdateCheck()).optional(true).defaultValue(String.valueOf(true)));
        this.addAttribute(new SimpleNodeAttribute("monitoring", this.configuration.getMonitoring()).optional(true).defaultValue(Configuration.DEFAULT_MONITORING.name().toLowerCase()));
        this.addAttribute(new SimpleNodeAttribute("dynamicConfig", this.configuration.getDynamicConfig()).optional(true).defaultValue(String.valueOf(true)));
        DiskStoreConfiguration diskStoreConfiguration = this.configuration.getDiskStoreConfiguration();
        if (diskStoreConfiguration != null) {
            this.addChildElement(new DiskStoreConfigurationElement(this, diskStoreConfiguration));
        }
        if ((transactionManagerLookupConfiguration = this.configuration.getTransactionManagerLookupConfiguration()) != null && !transactionManagerLookupConfiguration.equals(Configuration.DEFAULT_TRANSACTION_MANAGER_LOOKUP_CONFIG)) {
            this.addChildElement(new FactoryConfigurationElement(this, "transactionManagerLookup", transactionManagerLookupConfiguration));
        }
        if ((cacheManagerEventListenerFactoryConfiguration = this.configuration.getCacheManagerEventListenerFactoryConfiguration()) != null) {
            this.addChildElement(new FactoryConfigurationElement(this, "cacheManagerEventListenerFactory", cacheManagerEventListenerFactoryConfiguration));
        }
        if ((cacheManagerPeerProviderFactoryConfiguration = this.configuration.getCacheManagerPeerProviderFactoryConfiguration()) != null) {
            ConfigurationElement.addAllFactoryConfigsAsChildElements(this, "cacheManagerPeerProviderFactory", cacheManagerPeerProviderFactoryConfiguration);
        }
        if ((cacheManagerPeerListenerFactoryConfigurations = this.configuration.getCacheManagerPeerListenerFactoryConfigurations()) != null && !cacheManagerPeerListenerFactoryConfigurations.isEmpty()) {
            ConfigurationElement.addAllFactoryConfigsAsChildElements(this, "cacheManagerPeerListenerFactory", cacheManagerPeerListenerFactoryConfigurations);
        }
        this.addChildElement(new DefaultCacheConfigurationElement((NodeElement)this, this.configuration.getDefaultCacheConfiguration()));
        for (CacheConfiguration cacheConfiguration : this.configuration.getCacheConfigurations().values()) {
            this.addChildElement(new CacheConfigurationElement((NodeElement)this, cacheConfiguration));
        }
        TerracottaClientConfiguration terracottaConfiguration = this.configuration.getTerracottaConfiguration();
        if (terracottaConfiguration != null) {
            this.addChildElement(new TerracottaConfigConfigurationElement((NodeElement)this, terracottaConfiguration));
        }
    }
}

