/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl;

import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccessControlMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccessControlMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTAclRole.class);
            Expression exp = ExpressionFactory.inDbExp((String)"ROLE_ID", values);
            query.setQualifier(exp);
            List roles = query.fetchList();
            if (roles == null || roles.size() == 0) {
                return false;
            }
            SelectQuery EipTAclUserRoleMapSQL = Database.query(EipTAclUserRoleMap.class);
            EipTAclUserRoleMapSQL.andQualifier(ExpressionFactory.inDbExp((String)"ROLE_ID", values));
            List userRoleMaps = EipTAclUserRoleMapSQL.fetchList();
            Database.deleteAll((List)userRoleMaps);
            Database.deleteAll((List)roles);
            Database.commit();
            for (EipTAclRole role : roles) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(role.getRoleId().intValue(), 350, ALLocalizationUtils.getl10nFormat((String)"ACCESSCTL_EVENTLOG_DELETE", (Object[])new Object[]{role.getRoleName()}));
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccessControlMultiDelete.action", (Throwable)ex);
            return false;
        }
        return true;
    }
}

