/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.accessctl.AccessControlResultData;
import com.aimluck.eip.accessctl.bean.AccessControlFeatureBean;
import com.aimluck.eip.accessctl.util.AccessControlUtils;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccessControlSelectData
extends ALAbstractSelectData<EipTAclRole, EipTAclRole> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccessControlSelectData.class.getName());
    private int aclRoleSum;
    private List<AccessControlFeatureBean> portletFeatureList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        super.init(action, rundata, context);
    }

    public void loadPortletFeatureList(RunData rundata, Context context) {
        this.portletFeatureList = AccessControlUtils.getPortletFeatureList();
    }

    public ResultList<EipTAclRole> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTAclRole> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.aclRoleSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlSelectData.selectList", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<EipTAclRole> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTAclRole.class);
        ArrayList<String> featureIdList = new ArrayList<String>();
        for (AccessControlFeatureBean bean : this.portletFeatureList) {
            featureIdList.add(String.valueOf(bean.getFeatureId()));
        }
        Expression ex = ExpressionFactory.inDbExp((String)"eipTAclPortletFeature.FEATURE_ID", featureIdList);
        query.andQualifier(ex);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(EipTAclRole obj) {
        try {
            EipTAclRole record = obj;
            AccessControlResultData rd = new AccessControlResultData();
            rd.initField();
            rd.setAclRoleId(record.getRoleId().longValue());
            rd.setAclRoleName(record.getRoleName());
            rd.setFeatureName(record.getEipTAclPortletFeature().getFeatureAliasName());
            rd.setNote(record.getNote());
            int tmpAclType = record.getAclType();
            if (this.hasAcl(1, tmpAclType)) {
                rd.setAclList(true);
            }
            if (this.hasAcl(2, tmpAclType)) {
                rd.setAclDetail(true);
            }
            if (this.hasAcl(4, tmpAclType)) {
                rd.setAclInsert(true);
            }
            if (this.hasAcl(8, tmpAclType)) {
                rd.setAclUpdate(true);
            }
            if (this.hasAcl(16, tmpAclType)) {
                rd.setAclDelete(true);
            }
            if (this.hasAcl(32, tmpAclType)) {
                rd.setAclExport(true);
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)ALLocalizationUtils.getl10n((String)"ACCESSCTL_DATE_FORMAT")));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)ALLocalizationUtils.getl10n((String)"ACCESSCTL_DATE_FORMAT")));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    public EipTAclRole selectDetail(RunData rundata, Context context) {
        return AccessControlUtils.getEipTAclRole(rundata, context);
    }

    protected Object getResultDataDetail(EipTAclRole obj) {
        try {
            EipTAclRole record = obj;
            AccessControlResultData rd = new AccessControlResultData();
            rd.initField();
            rd.setAclRoleId(record.getRoleId().longValue());
            rd.setAclRoleName(record.getRoleName());
            rd.setFeatureName(record.getEipTAclPortletFeature().getFeatureAliasName());
            rd.setNote(record.getNote());
            int tmpAclType = record.getAclType();
            if (this.hasAcl(1, tmpAclType)) {
                rd.setAclList(true);
            }
            if (this.hasAcl(2, tmpAclType)) {
                rd.setAclDetail(true);
            }
            if (this.hasAcl(4, tmpAclType)) {
                rd.setAclInsert(true);
            }
            if (this.hasAcl(8, tmpAclType)) {
                rd.setAclUpdate(true);
            }
            if (this.hasAcl(16, tmpAclType)) {
                rd.setAclDelete(true);
            }
            if (this.hasAcl(32, tmpAclType)) {
                rd.setAclExport(true);
            }
            ArrayList<String> unamelist = new ArrayList<String>();
            EipTAclUserRoleMap map = null;
            TurbineUser tuser = null;
            List<EipTAclUserRoleMap> maps = AccessControlUtils.getEipTAclUserRoleMaps(record.getRoleId());
            if (maps != null && maps.size() > 0) {
                int size = maps.size();
                for (int i = 0; i < size; ++i) {
                    map = maps.get(i);
                    tuser = map.getTurbineUser();
                    if ("PENDING".equals(tuser.getConfirmValue())) continue;
                    unamelist.add(new StringBuffer().append(tuser.getLastName()).append(" ").append(tuser.getFirstName()).toString());
                }
                rd.addUserNameList(unamelist);
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)ALLocalizationUtils.getl10n((String)"ACCESSCTL_DATE_FORMAT")));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)ALLocalizationUtils.getl10n((String)"ACCESSCTL_DATE_FORMAT")));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlSelectData.getResultDataDetail", (Throwable)ex);
            return null;
        }
    }

    private boolean hasAcl(int defineAclType, int aclType) {
        return (aclType & defineAclType) == defineAclType;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("acl_role_name", "roleName");
        map.putValue("feature_alias_name", "eipTAclPortletFeature.featureAliasName");
        map.putValue("feature", "eipTAclPortletFeature.FEATURE_ID");
        return map;
    }

    public List<AccessControlFeatureBean> getPortletFeatureList() {
        return this.portletFeatureList;
    }

    public int getAclRoleSum() {
        return this.aclRoleSum;
    }
}

