/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.todo.ToDoSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoCategoryMultiDelete.class.getName());
    private String aclPortletFeature;

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Object[] objs = rundata.getParameters().getKeys();
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            if (!objs[i].toString().startsWith("check")) continue;
            String str = rundata.getParameters().getString(objs[i].toString());
            values.add(Integer.valueOf(str));
        }
        Expression exp1 = ExpressionFactory.noMatchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        Expression exp2 = ExpressionFactory.inDbExp((String)"CATEGORY_ID", values);
        this.aclPortletFeature = Database.query(EipTTodoCategory.class).andQualifier(exp1.andExp(exp2)).getCount() > 0 ? "todo_category_other" : "todo_category_self";
        return super.doCheckAclPermission(rundata, context, defineAclType);
    }

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            Expression exp1 = ExpressionFactory.inDbExp((String)"CATEGORY_ID", values);
            List categoryList = Database.query(EipTTodoCategory.class, (Expression)exp1).fetchList();
            if (categoryList == null || categoryList.size() == 0) {
                return false;
            }
            for (EipTTodoCategory category : categoryList) {
                if (category.getEipTTodoArray().size() <= 0) continue;
                msgList.add("1\u3064\u4ee5\u4e0a\u306eToDo\u3092\u542b\u3080\u30ab\u30c6\u30b4\u30ea\u3092\u524a\u9664\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            for (EipTTodoCategory category : categoryList) {
                Integer entityId = category.getCategoryId();
                String categoryName = category.getCategoryName();
                Database.delete((Persistent)category);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 131, categoryName);
            }
            String filtername = ToDoSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[ToDoCategoryMultiDelete]", t);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

