/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoFormData.class.getName());
    private ALStringField todo_name;
    private ALNumberField category_id;
    private ALNumberField user_id;
    private ALNumberField priority;
    private ALNumberField state;
    private ALStringField note;
    private ALDateField start_date;
    private ALDateField end_date;
    private ALStringField start_date_check;
    private ALStringField end_date_check;
    private List<ToDoCategoryResultData> categoryList;
    private int currentYear;
    private ALStringField category_name;
    private boolean is_new_category;
    private ALStringField public_flag;
    private ALStringField addon_schedule_flg;
    private EipTTodoCategory category;
    private int login_user_id;
    private String aclPortletFeature;
    private ArrayList<ALEipGroup> myGroupList;
    private boolean hasAclInsertTodoOther;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTTodo todo;
        super.init(action, rundata, context);
        this.is_new_category = rundata.getParameters().getBoolean("is_new_category");
        this.login_user_id = ALEipUtils.getUserId((RunData)rundata);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.setMyGroupList(new ArrayList<ALEipGroup>());
        for (ALEipGroup group : myGroups) {
            this.getMyGroupList().add(group);
        }
        String todoId = rundata.getParameters().getString("entityid");
        String userId = rundata.getParameters().getString("user_id");
        this.aclPortletFeature = todoId == null || todoId.equals("new") ? (userId != null && !userId.equals(String.valueOf(this.login_user_id)) ? "todo_todo_other" : "todo_todo_self") : ((todo = ToDoUtils.getEipTTodo(rundata, context, true)) != null && todo.getTurbineUser().getUserId() != this.login_user_id ? "todo_todo_other" : "todo_todo_self");
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclInsertTodoOther = aclhandler.hasAuthority(this.login_user_id, "todo_todo_other", 4);
    }

    public void initField() {
        this.todo_name = new ALStringField();
        this.todo_name.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_TITLE"));
        this.todo_name.setTrim(true);
        this.category_id = new ALNumberField();
        this.category_id.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_CATEGORY"));
        this.user_id = new ALNumberField();
        this.user_id.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_PREPARED"));
        this.priority = new ALNumberField(3L);
        this.priority.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_PRIORITY"));
        this.state = new ALNumberField();
        this.state.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_STATE"));
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_MEMO"));
        this.note.setTrim(false);
        this.start_date = new ALDateField();
        this.start_date.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_START_DATE"));
        this.start_date.setValue(new Date());
        this.end_date = new ALDateField();
        this.end_date.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_END_DATE"));
        this.end_date.setValue(new Date());
        this.start_date_check = new ALStringField();
        this.start_date_check.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_NOT_SET"));
        this.end_date_check = new ALStringField();
        this.end_date_check.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_NOT_SET"));
        this.currentYear = Calendar.getInstance().get(1);
        this.category_name = new ALStringField();
        this.category_name.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_CATEGORY_NAME"));
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_PUBLIC"));
        this.public_flag.setValue("T");
        this.public_flag.setTrim(true);
        this.addon_schedule_flg = new ALStringField();
        this.addon_schedule_flg.setFieldName(ALLocalizationUtils.getl10n((String)"TODO_SETFIELDNAME_ADD_ON_SCHEDULE_FLG"));
        this.addon_schedule_flg.setValue("T");
        this.addon_schedule_flg.setTrim(true);
    }

    public void loadCategoryList(RunData rundata) {
        this.categoryList = ToDoUtils.getCategoryList(rundata);
    }

    protected void setValidator() {
        this.todo_name.setNotNull(true);
        this.todo_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
        if (this.is_new_category) {
            this.category_name.setNotNull(true);
            this.category_name.limitMaxLength(50);
        }
        this.user_id.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        try {
            Expression exp = ExpressionFactory.matchExp((String)"categoryName", (Object)this.category_name.getValue());
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)0);
            Expression exp3 = ExpressionFactory.matchExp((String)"userId", (Object)this.login_user_id);
            if (this.is_new_category && Database.query(EipTTodoCategory.class, (Expression)exp).andQualifier(exp2.orExp(exp3)).fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"TODO_CATEGORY_NAME_ALREADY_REGISTERED", (Object[])new Object[]{this.category_name.toString()}));
            }
            if (Database.get(TurbineUser.class, (Object)this.user_id.getValue()) == null) {
                msgList.add(ALLocalizationUtils.getl10n((String)"TODO_ALERT_NO_PREPARED"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return false;
        }
        boolean isStartDate = false;
        this.todo_name.validate(msgList);
        if (this.start_date_check.getValue() == null) {
            isStartDate = this.start_date.validate(msgList);
        }
        if (this.end_date_check.getValue() == null && this.end_date.validate(msgList) && isStartDate) {
            try {
                if (this.end_date.getValue().getDate().before(this.start_date.getValue().getDate())) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"TODO_ALERT_SET_TDATE"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"todo", (Throwable)e);
            }
        }
        this.note.validate(msgList);
        if (this.is_new_category) {
            this.category_name.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        String date1 = null;
        try {
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            this.todo_name.setValue(todo.getTodoName());
            this.category_id.setValue(todo.getEipTTodoCategory().getCategoryId().longValue());
            if (ToDoUtils.isEmptyDate(todo.getStartDate())) {
                this.start_date_check.setValue("TRUE");
                this.start_date.setValue(date1);
            } else {
                this.start_date.setValue(todo.getStartDate());
            }
            if (ToDoUtils.isEmptyDate(todo.getEndDate())) {
                this.end_date_check.setValue("TRUE");
                this.end_date.setValue(date1);
            } else {
                this.end_date.setValue(todo.getEndDate());
            }
            this.state.setValue(todo.getState().longValue());
            this.priority.setValue(todo.getPriority().longValue());
            this.note.setValue(todo.getNote());
            this.public_flag.setValue(todo.getPublicFlag());
            this.user_id.setValue((long)todo.getTurbineUser().getUserId().intValue());
            this.addon_schedule_flg.setValue(todo.getAddonScheduleFlg());
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            int entityId = todo.getTodoId();
            String todoName = todo.getTodoName();
            Database.delete((Persistent)todo);
            Database.commit();
            TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"todo", (String)todo.getTodoId().toString());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 130, todoName);
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[ToDoFormData]", t);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        block16: {
            try {
                if (this.is_new_category) {
                    if (!this.insertCategoryData(rundata, context, msgList)) {
                        return false;
                    }
                } else {
                    this.category = ToDoUtils.getEipTTodoCategory(this.category_id.getValue());
                }
                EipTTodo todo = (EipTTodo)Database.create(EipTTodo.class);
                todo.setTodoName(this.todo_name.getValue());
                todo.setEipTTodoCategory(this.category);
                TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.user_id.getValue());
                todo.setTurbineUser(tuser);
                if (this.start_date_check.getValue() == null) {
                    todo.setStartDate(this.start_date.getValue().getDate());
                } else {
                    todo.setStartDate(ToDoUtils.getEmptyDate());
                }
                if (this.end_date_check.getValue() == null) {
                    todo.setEndDate(this.end_date.getValue().getDate());
                } else {
                    todo.setEndDate(ToDoUtils.getEmptyDate());
                }
                todo.setState(Short.valueOf((short)this.state.getValue()));
                todo.setPriority(Short.valueOf((short)this.priority.getValue()));
                todo.setNote(this.note.getValue());
                todo.setPublicFlag(this.public_flag.getValue());
                todo.setAddonScheduleFlg(this.addon_schedule_flg.getValue());
                todo.setCreateDate(Calendar.getInstance().getTime());
                todo.setUpdateDate(Calendar.getInstance().getTime());
                todo.setCreateUserId(Integer.valueOf(this.login_user_id));
                Database.commit();
                if (this.category != null) {
                    this.category_id.setValue(this.category.getCategoryId().longValue());
                }
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(todo.getTodoId().intValue(), 130, this.todo_name.getValue());
                if (this.is_new_category) {
                    ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.category.getCategoryId().intValue(), 131, this.category_name.getValue());
                }
                String loginName = ALEipUtils.getLoginName((RunData)rundata);
                ArrayList<String> recipients = new ArrayList<String>();
                if (this.aclPortletFeature.equals("todo_todo_other")) {
                    recipients.add(todo.getTurbineUser().getLoginName());
                }
                ToDoUtils.createToDoActivity(todo, loginName, recipients, true, this.login_user_id);
                if (!this.aclPortletFeature.equals("todo_todo_other")) break block16;
                try {
                    ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
                    memberList.add(ALEipUtils.getALEipUser((int)todo.getTurbineUser().getUserId()));
                    int msgType = ALMailUtils.getSendDestType((int)25);
                    if (msgType > 0) {
                        List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                        String subject = "[" + ALOrgUtilsService.getAlias() + "]ToDo";
                        String orgId = Database.getDomainName();
                        ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                        for (ALEipUserAddr destMember : destMemberList) {
                            ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                            message.setPcSubject(subject);
                            message.setCellularSubject(subject);
                            message.setPcBody(ToDoUtils.createMsgForPcTmpl(rundata, todo, memberList, true));
                            message.setCellularBody(ToDoUtils.createMsgForPcTmpl(rundata, todo, memberList, true));
                            messageList.add(message);
                        }
                        ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)25)));
                    }
                }
                catch (Exception ex) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"TODO_ALERT_DONOT_SEND"));
                    logger.error((Object)"todo", (Throwable)ex);
                    return false;
                }
            }
            catch (Throwable t) {
                Database.rollback();
                logger.error((Object)"[ToDoFormData]", t);
                return false;
            }
        }
        return true;
    }

    private boolean insertCategoryData(RunData rundata, Context context, List<String> msgList) {
        try {
            String originalFeature = this.getAclPortletFeature();
            this.setAclPortletFeature("todo_category_self");
            this.doCheckAclPermission(rundata, context, 4);
            this.setAclPortletFeature(originalFeature);
            this.category = (EipTTodoCategory)Database.create(EipTTodoCategory.class);
            this.category.setCategoryName(this.category_name.getValue());
            this.category.setTurbineUser(ALEipUtils.getTurbineUser((int)ALEipUtils.getUserId((RunData)rundata)));
            this.category.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            this.category.setCreateDate(Calendar.getInstance().getTime());
            this.category.setUpdateDate(Calendar.getInstance().getTime());
        }
        catch (ALPermissionException e) {
            msgList.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"todo", (Throwable)ex);
            msgList.add(ALLocalizationUtils.getl10n((String)"TODO_ALERT_GET_ERROR"));
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        block17: {
            try {
                EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
                if (todo == null) {
                    return false;
                }
                if (this.is_new_category) {
                    if (!this.insertCategoryData(rundata, context, msgList)) {
                        return false;
                    }
                } else {
                    this.category = ToDoUtils.getEipTTodoCategory(this.category_id.getValue());
                }
                todo.setTodoName(this.todo_name.getValue());
                todo.setEipTTodoCategory(this.category);
                TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.user_id.getValue());
                todo.setTurbineUser(tuser);
                if (this.start_date_check.getValue() == null) {
                    todo.setStartDate(this.start_date.getValue().getDate());
                } else {
                    todo.setStartDate(ToDoUtils.getEmptyDate());
                }
                if (this.end_date_check.getValue() == null) {
                    todo.setEndDate(this.end_date.getValue().getDate());
                } else {
                    todo.setEndDate(ToDoUtils.getEmptyDate());
                }
                todo.setState(Short.valueOf((short)this.state.getValue()));
                todo.setPriority(Short.valueOf((short)this.priority.getValue()));
                todo.setNote(this.note.getValue());
                todo.setPublicFlag(this.public_flag.getValue());
                todo.setAddonScheduleFlg(this.addon_schedule_flg.getValue());
                todo.setUpdateDate(Calendar.getInstance().getTime());
                todo.setCreateUserId(Integer.valueOf(this.login_user_id));
                Database.commit();
                if (this.category != null) {
                    this.category_id.setValue(this.category.getCategoryId().longValue());
                }
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(todo.getTodoId().intValue(), 130, this.todo_name.getValue());
                if (this.is_new_category) {
                    ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.category.getCategoryId().intValue(), 131, this.category_name.getValue(), "insert");
                }
                String loginName = ALEipUtils.getLoginName((RunData)rundata);
                ArrayList<String> recipients = new ArrayList<String>();
                if (this.aclPortletFeature.equals("todo_todo_other")) {
                    recipients.add(todo.getTurbineUser().getLoginName());
                }
                ToDoUtils.createToDoActivity(todo, loginName, recipients, false, this.login_user_id);
                if (!this.aclPortletFeature.equals("todo_todo_other")) break block17;
                try {
                    ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
                    memberList.add(ALEipUtils.getALEipUser((int)todo.getUserId()));
                    int msgType = ALMailUtils.getSendDestType((int)25);
                    if (msgType > 0) {
                        List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                        String subject = "[" + ALOrgUtilsService.getAlias() + "]ToDo";
                        String orgId = Database.getDomainName();
                        ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                        for (ALEipUserAddr destMember : destMemberList) {
                            ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                            message.setPcSubject(subject);
                            message.setCellularSubject(subject);
                            message.setPcBody(ToDoUtils.createMsgForPcTmpl(rundata, todo, memberList, false));
                            message.setCellularBody(ToDoUtils.createMsgForPcTmpl(rundata, todo, memberList, false));
                            messageList.add(message);
                        }
                        ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)25)));
                    }
                }
                catch (Exception ex) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"TODO_ALERT_DONOT_SEND"));
                    logger.error((Object)"todo", (Throwable)ex);
                    return false;
                }
            }
            catch (Throwable t) {
                Database.rollback();
                logger.error((Object)"[ToDoFormData]", t);
                return false;
            }
        }
        return true;
    }

    public ALNumberField getCategoryId() {
        return this.category_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALNumberField getPriority() {
        return this.priority;
    }

    public ALNumberField getState() {
        return this.state;
    }

    public ALStringField getTodoName() {
        return this.todo_name;
    }

    public ALDateField getEndDate() {
        return this.end_date;
    }

    public ALDateField getStartDate() {
        return this.start_date;
    }

    public List<ToDoCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public ALStringField getEndDateCheck() {
        return this.end_date_check;
    }

    public ALStringField getStartDateCheck() {
        return this.start_date_check;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public boolean isNewCategory() {
        return this.is_new_category;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public ALStringField getAddonScheduleFlg() {
        return this.addon_schedule_flg;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setAclPortletFeature(String aclPortletFeature) {
        this.aclPortletFeature = aclPortletFeature;
    }

    public void setCategoryId(long i) {
        this.category_id.setValue(i);
    }

    public void setMyGroupList(ArrayList<ALEipGroup> myGroupList) {
        this.myGroupList = myGroupList;
    }

    public ArrayList<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public void setLoginUserId(int user_id) {
        this.login_user_id = user_id;
    }

    public int getLoginUserId() {
        return this.login_user_id;
    }

    public void setUserId(ALNumberField todo_user_id) {
        this.user_id = todo_user_id;
    }

    public ALNumberField getUserId() {
        return this.user_id;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public boolean hasAclInsertTodoOther() {
        return this.hasAclInsertTodoOther;
    }
}

