/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoMultiStateUpdate
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoMultiStateUpdate.class.getName());
    private String aclPortletFeature;

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        ArrayList<String> values = new ArrayList<String>();
        Object[] objs = rundata.getParameters().getKeys();
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            if (!objs[i].toString().startsWith("check")) continue;
            String str = rundata.getParameters().getString(objs[i].toString());
            values.add(str);
        }
        Expression exp1 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
        Expression exp2 = ExpressionFactory.inDbExp((String)"TODO_ID", values);
        this.aclPortletFeature = Database.query(EipTTodo.class).andQualifier(exp1).andQualifier(exp2).getCount() > 0 ? "todo_todo_other" : "todo_todo_self";
        return super.doCheckAclPermission(rundata, context, defineAclType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            Expression exp1 = ExpressionFactory.inDbExp((String)"TODO_ID", values);
            List todoList = Database.query(EipTTodo.class).andQualifier(exp1).fetchList();
            if (todoList == null) return false;
            if (todoList.size() == 0) {
                return false;
            }
            for (EipTTodo todo : todoList) {
                todo.setState(Short.valueOf((short)100));
            }
            Database.commit();
            Iterator iterator = todoList.iterator();
            while (iterator.hasNext()) {
                EipTTodo todo;
                todo = (EipTTodo)iterator.next();
                if (!this.aclPortletFeature.equals("todo_todo_other")) continue;
                try {
                    ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
                    memberList.add(ALEipUtils.getALEipUser((int)todo.getUserId()));
                    int msgType = ALMailUtils.getSendDestType((int)25);
                    if (msgType <= 0) continue;
                    List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]ToDo";
                    String orgId = Database.getDomainName();
                    ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                    for (ALEipUserAddr destMember : destMemberList) {
                        ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                        message.setPcSubject(subject);
                        message.setCellularSubject(subject);
                        message.setPcBody(ToDoUtils.createMsgForPc(rundata, todo, memberList, false));
                        message.setCellularBody(ToDoUtils.createMsgForPc(rundata, todo, memberList, false));
                        messageList.add(message);
                    }
                    ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)25)));
                }
                catch (Exception ex) {
                    msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                    logger.error((Object)"todo", (Throwable)ex);
                    return false;
                }
            }
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[ToDoMultiStateUpdate]", t);
            return false;
        }
    }

    protected int getDefineAclType() {
        return 8;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

