/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.AjaxScheduleMonthlySelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AjaxScheduleWeeklyGroupEmptySelectData
extends AjaxScheduleMonthlySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AjaxScheduleWeeklyGroupEmptySelectData.class.getName());
    private String acl_feat;
    private List<ALEipGroup> groups;
    private List<ALEipGroup> facilityGroups;
    private String selectedGroup;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.acl_feat = "schedule_self";
        this.initFacilityList(rundata);
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.facilityGroups = ALEipUtils.getALEipGroups();
        this.selectedGroup = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p8h-cgrp");
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_start")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_start", (String)rundata.getParameters().getString("view_start"));
        }
        super.init(action, rundata, context);
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return new ResultList();
    }

    @Override
    protected VEipTScheduleList selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    @Override
    protected Object getResultData(VEipTScheduleList obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    @Override
    protected Object getResultDataDetail(VEipTScheduleList obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    @Override
    protected Attributes getColumnMap() {
        return null;
    }

    public String getViewtype() {
        return "calendar";
    }

    public String getAclPortletFeature() {
        return this.acl_feat;
    }

    private boolean initFacilityList(RunData rundata) {
        ArrayList<Long> facilityList = null;
        String[] str = rundata.getParameters().getStrings("m_id");
        ArrayList<Integer> f_list = new ArrayList<Integer>();
        int len = 0;
        if (str == null || str.length == 0) {
            return false;
        }
        for (String s_item : str) {
            if (!s_item.startsWith("f")) continue;
            f_list.add(Integer.parseInt(s_item.substring(1)));
        }
        if (f_list.size() == 0) {
            return false;
        }
        ArrayList temp_list = new ArrayList();
        facilityList = new ArrayList<Long>();
        SelectQuery facility_query = Database.query(EipMFacility.class);
        Expression exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", f_list);
        facility_query.setQualifier(exp);
        temp_list.addAll(FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery)facility_query));
        int tmpsize = temp_list.size();
        for (int i = 0; i < tmpsize; ++i) {
            FacilityResultData facility = (FacilityResultData)temp_list.get(i);
            facilityList.add(facility.getFacilityId().getValue());
        }
        if (facilityList.size() == 0 || facilityList == null) {
            return false;
        }
        this.acl_feat = "schedule_other";
        return true;
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    @Deprecated
    public List<ALEipUser> getMemberListByPost(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public List<ALEipGroup> getFacilityGroupList() {
        return this.facilityGroups;
    }

    public String getFacilityName(String fname) {
        return "f;" + fname;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(String selectedGroup) {
        this.selectedGroup = selectedGroup;
    }
}

