/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.CellScheduleOnedaySelectData;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleOnedaySelectByMemberData
extends CellScheduleOnedaySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleOnedaySelectByMemberData.class.getName());
    private ALEipUser targerUser;
    private List<ScheduleToDoResultData> todoList;
    private String portletId;
    private int userid;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userid = ALEipUtils.getUserId((RunData)rundata);
        String s = rundata.getParameters().getString("selectedmember");
        if (s != null) {
            this.targerUser = ALEipUtils.getALEipUser((int)Integer.parseInt(s));
        } else {
            s = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_otheruser_id");
            this.targerUser = ALEipUtils.getALEipUser((int)Integer.parseInt(s));
        }
    }

    @Override
    protected List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getViewDate().getValue());
        cal.add(5, 1);
        cal.add(14, -1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        return ScheduleUtils.getScheduleList(this.userid, this.getViewDate().getValue(), field.getValue(), Arrays.asList((int)this.targerUser.getUserId().getValue()), null);
    }

    @Override
    public void loadToDo(RunData rundata, Context context) {
        this.todoList = new ArrayList<ScheduleToDoResultData>();
        try {
            SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(rundata, context);
            List todos = query.fetchList();
            int todosize = todos.size();
            for (int i = 0; i < todosize; ++i) {
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = this.getPortletURItoTodo(rundata, record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                this.todoList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return;
        }
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = (int)this.targerUser.getUserId().getValue();
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        CellScheduleResultData rd = new CellScheduleResultData();
        CellScheduleResultData rd2 = new CellScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            boolean hidden;
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.getViewDate(), record.getRepeatPattern(), record.getStartDate(), record.getEndDate())) {
                return rd;
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setName(record.getName());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setPattern(record.getRepeatPattern());
            boolean is_member = record.isMember();
            boolean publicable = record.getPublicFlag().equals("O");
            if (!publicable && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
            }
            if ((hidden = record.getPublicFlag().equals("P")) && !is_member) {
                return null;
            }
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    public ALEipUser getTargerUser() {
        return this.targerUser;
    }

    public void setTargerUser(ALEipUser targerUser) {
        this.targerUser = targerUser;
    }

    @Override
    public List<ScheduleToDoResultData> getToDoResultDataList() {
        return this.todoList;
    }

    @Override
    public void setPortletId(String id) {
        this.portletId = id;
    }

    public String getAliasNameText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_GO_SCHEDULE", (Object[])new Object[]{this.targerUser.getAliasName().toString()});
    }

    public String getAliasNameOnedayListText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_ONES_ONEDAY_LIST", (Object[])new Object[]{this.targerUser.getAliasName().toString()});
    }
}

