/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleOnedaySelectData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleOnedaySelectData
extends ScheduleOnedaySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleOnedaySelectData.class.getName());

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List<VEipTScheduleList> resultBaseList = this.getScheduleList(rundata, context);
            List<VEipTScheduleList> resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
            ArrayList<VEipTScheduleList> list = new ArrayList<VEipTScheduleList>();
            int resultSize = resultList.size();
            int DummySize = 0;
            boolean flg = false;
            boolean canAdd = true;
            for (int i = 0; i < resultSize; ++i) {
                VEipTScheduleList record = resultList.get(i);
                canAdd = true;
                if (!record.getStatus().equals("D")) {
                    if (!flg) {
                        DummySize = i;
                        flg = true;
                    }
                    for (int j = 0; j < DummySize; ++j) {
                        VEipTScheduleList record2 = resultList.get(j);
                        if (record.getRepeatPattern().equals("N") || !record.getScheduleId().equals(record2.getParentId())) continue;
                        canAdd = false;
                        break;
                    }
                } else {
                    canAdd = false;
                }
                if (!canAdd) continue;
                list.add(record);
            }
            Collections.sort(list, new Comparator<VEipTScheduleList>(){

                @Override
                public int compare(VEipTScheduleList a, VEipTScheduleList b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    if (a.getRepeatPattern().equals("S")) {
                        if (!b.getRepeatPattern().equals("S")) {
                            return -1;
                        }
                    } else if (b.getRepeatPattern().equals("S")) {
                        return 1;
                    }
                    cal.setTime(a.getStartDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(b.getStartDate());
                    cal2.set(0, 0, 0);
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    cal.setTime(a.getEndDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(b.getEndDate());
                    cal2.set(0, 0, 0);
                    return cal.getTime().compareTo(cal2.getTime());
                }
            });
            if (this.viewToDo == 1) {
                this.loadToDo(rundata, context);
            }
            return new ResultList(list);
        }
        catch (Exception e) {
            logger.error((Object)"[CellScheduleOnedaySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    protected List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getViewDate().getValue());
        cal.add(5, 1);
        cal.add(14, -1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        Integer userid = ALEipUtils.getUserId((RunData)rundata);
        return ScheduleUtils.getScheduleList(userid, this.getViewDate().getValue(), field.getValue(), Arrays.asList(userid), null);
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        CellScheduleResultData rd = new CellScheduleResultData();
        CellScheduleResultData rd2 = new CellScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return null;
            }
            if (!ScheduleUtils.isView(this.getViewDate(), record.getRepeatPattern(), record.getStartDate(), record.getEndDate())) {
                return null;
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setName(record.getName());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setPattern(record.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[CellScheduleOnedaySelectData]", (Throwable)e);
            return null;
        }
        return rd;
    }

    @Override
    protected String getPortletURItoTodo(RunData rundata, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoDetailPaneForCell(rundata, "Cell_ToDo", entityid, schedulePortletId);
    }
}

