/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.Date;

public class ScheduleResultData
implements ALData,
Cloneable {
    private ALNumberField schedule_id;
    private ALNumberField parent_id;
    private ALStringField type;
    private ALDateTimeField start_date;
    private int start_date_time;
    private ALDateTimeField end_date;
    private int end_date_time;
    private ALStringField name;
    private ALStringField description;
    private ALStringField place;
    private String ptn;
    private String format = "H:mm";
    private boolean is_owner;
    private boolean is_tmpreserve;
    private boolean is_duplicate;
    private boolean is_public;
    private boolean is_hidden;
    private boolean is_loginuser;
    private boolean is_member;
    private boolean is_confirm;
    private boolean is_repeat;
    private boolean is_dummy;
    private boolean is_editable;
    private boolean is_daystart;
    private boolean is_term;
    private int rowspan;
    private ALStringField common_category_name;

    public void initField() {
        this.name = new ALStringField();
        this.type = new ALStringField();
        this.place = new ALStringField();
        this.description = new ALStringField();
        this.schedule_id = new ALNumberField();
        this.parent_id = new ALNumberField();
        this.start_date = new ALDateTimeField(this.format);
        this.end_date = new ALDateTimeField(this.format);
        this.common_category_name = new ALStringField();
        this.is_owner = true;
        this.is_tmpreserve = false;
        this.is_duplicate = false;
        this.is_public = true;
        this.is_hidden = false;
        this.is_loginuser = true;
        this.is_member = true;
        this.is_confirm = false;
        this.is_repeat = false;
        this.is_dummy = false;
        this.is_daystart = false;
        this.is_term = false;
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public int getEndDateTime() {
        return this.end_date_time;
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public int getStartDateTime() {
        return this.start_date_time;
    }

    public void setEndDate(Date date) {
        this.end_date.setValue(date);
        int hh = Integer.parseInt(this.end_date.getHour());
        int mm = Integer.parseInt(this.end_date.getMinute());
        this.end_date_time = hh * 60 + mm;
    }

    public void setStartDate(Date date) {
        this.start_date.setValue(date);
        int hh = Integer.parseInt(this.start_date.getHour());
        int mm = Integer.parseInt(this.start_date.getMinute());
        this.start_date_time = hh * 60 + mm;
    }

    public ALStringField getName() {
        return this.name;
    }

    public String getWbrName() {
        return ALCommonUtils.replaceToAutoCR((String)this.name.toString());
    }

    public ALStringField getDescription() {
        return this.description;
    }

    public ALStringField getPlace() {
        return this.place;
    }

    public boolean isShowDetail() {
        return this.is_loginuser || this.is_public || this.is_owner || this.is_member;
    }

    public void setName(String string) {
        this.name.setValue(string);
    }

    public void setDescription(String string) {
        this.description.setValue(string);
    }

    public void setPlace(String string) {
        this.place.setValue(string);
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public ALNumberField getScheduleId() {
        return this.schedule_id;
    }

    public void setScheduleId(int number) {
        this.schedule_id.setValue((long)number);
    }

    public ALNumberField getParentId() {
        return this.parent_id;
    }

    public void setParentId(int number) {
        this.parent_id.setValue((long)number);
    }

    public void setOwner(boolean bool) {
        this.is_owner = bool;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public boolean isTmpreserve() {
        return this.is_tmpreserve;
    }

    public boolean isPublic() {
        return this.is_public;
    }

    public void setTmpreserve(boolean bool) {
        this.is_tmpreserve = bool;
    }

    public boolean isConfirm() {
        return this.is_confirm;
    }

    public void setConfirm(boolean bool) {
        this.is_confirm = bool;
    }

    public boolean isDuplicate() {
        return this.is_duplicate;
    }

    public void setDuplicate(boolean bool) {
        this.is_duplicate = bool;
    }

    public void setPublic(boolean bool) {
        this.is_public = bool;
    }

    public boolean isHidden() {
        return this.is_hidden;
    }

    public void setHidden(boolean bool) {
        this.is_hidden = bool;
    }

    public boolean isPrivate() {
        return !this.is_public && this.is_hidden;
    }

    public boolean isLoginuser() {
        return this.is_loginuser;
    }

    public void setLoginuser(boolean b) {
        this.is_loginuser = b;
    }

    public boolean isMember() {
        return this.is_member;
    }

    public void setMember(boolean b) {
        this.is_member = b;
    }

    public boolean isRepeat() {
        return this.is_repeat;
    }

    public void setRepeat(boolean bool) {
        this.is_repeat = bool;
    }

    public boolean isDummy() {
        return this.is_dummy;
    }

    public void setDummy(boolean bool) {
        this.is_dummy = bool;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public void setRowspan(int number) {
        this.rowspan = number;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public String getPattern() {
        return this.ptn;
    }

    public void setPattern(String string) {
        this.ptn = string;
    }

    public boolean isEditable() {
        return this.is_editable;
    }

    public void setEditFlag(boolean bool) {
        this.is_editable = bool;
    }

    public String getDate() {
        if (this.start_date.getValue().equals(this.end_date.getValue())) {
            return this.start_date.toString();
        }
        if (this.start_date.getYear().equals(this.end_date.getYear()) && this.start_date.getMonth().equals(this.end_date.getMonth()) && this.start_date.getDay().equals(this.end_date.getDay()) || this.is_repeat) {
            return new StringBuffer().append(this.start_date.toString()).append(" ").append('-').append(" ").append(this.end_date.toString()).toString();
        }
        return new StringBuffer().append(this.start_date.toString()).append(" ").append('-').append(" ").append("24:00").toString();
    }

    public String getDate2() {
        if (this.start_date.getHour().equals(this.end_date.getHour()) && this.start_date.getMinute().equals(this.end_date.getMinute())) {
            return this.start_date.toString();
        }
        if (this.start_date.getYear().equals(this.end_date.getYear()) && this.start_date.getMonth().equals(this.end_date.getMonth()) && this.start_date.getDay().equals(this.end_date.getDay()) || this.is_repeat) {
            return new StringBuffer().append(this.start_date.toString()).append(" - ").append(this.end_date.toString()).toString();
        }
        return new StringBuffer().append(this.start_date.toString()).append(" - ").append("24:00").toString();
    }

    public ALStringField getCommonCategoryName() {
        return this.common_category_name;
    }

    public void setCommonCategoryName(String string) {
        this.common_category_name.setValue(string);
    }

    public void setType(String str) {
        this.type.setValue(str);
    }

    public String getType() {
        return this.type.toString();
    }

    public String getSpanDateText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_UNTIL_SPAN", (Object[])new Object[]{this.start_date.getYear(), this.start_date.getMonth(), this.start_date.getDay(), this.start_date.getDayOfWeek(), this.end_date.getYear(), this.end_date.getMonth(), this.end_date.getDay(), this.end_date.getDayOfWeek()});
    }

    public void setDayStart(boolean b) {
        this.is_daystart = b;
    }

    public boolean isDayStart() {
        return this.is_daystart;
    }

    public void setTerm(boolean b) {
        this.is_term = b;
    }

    public boolean isTerm() {
        return this.is_term;
    }
}

