/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteFormData.class.getName());
    public final int MSG_TYPE_NON_ADDR_PC = 1;
    public final int MSG_TYPE_NON_ADDR_CELL = 2;
    public final int MSG_TYPE_NON_ADDR_PC_CELL = 3;
    public final int MSG_TYPE_NON_RECIPIENT = 4;
    public final int MSG_TYPE_NON_MAILACCOUNT = 5;
    private ALNumberField note_id;
    private ALStringField src_user_id;
    private ALStringField dest_user_id;
    private ALStringField dest_user_name;
    private ALNumberField dest_post_id;
    private ALStringField client_name;
    private ALStringField company_name;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField email_address;
    private ALStringField add_dest_type_pc;
    private ALStringField add_dest_type_cellphone;
    private ALStringField subject_type;
    private ALStringField custom_subject;
    private ALStringField note_stat;
    private ALStringField message;
    private ALDateTimeField accept_date;
    private ALDateTimeField confirm_date;
    private ALDateTimeField create_date;
    private ALDateTimeField update_date;
    private int currentYear;
    private ALStringField view_type = null;
    private List<ALEipGroup> myGroupList = null;
    private String target_group_name;
    private final int msg_type = 0;
    private List<ALEipUser> memberList;
    private ALEipUser loginUser;
    private String orgId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.target_group_name = NoteUtils.getTargetGroupName(rundata, context);
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList<ALEipGroup>();
        for (ALEipGroup group : myGroups) {
            this.myGroupList.add(group);
        }
        this.orgId = Database.getDomainName();
        ParameterParser parser = rundata.getParameters();
        String dest_user_id_string = parser.getString("dest_user_id");
        if (dest_user_id_string != null) {
            this.dest_user_id.setValue(dest_user_id_string);
        } else {
            this.dest_user_id.setValue("");
        }
    }

    protected void setValidator() {
        this.dest_user_id.setNotNull(true);
        this.dest_user_id.limitMaxLength(50);
        this.dest_user_name.setNotNull(true);
        this.dest_user_name.limitMaxLength(50);
        this.client_name.setNotNull(true);
        this.client_name.limitMaxLength(50);
        this.company_name.setNotNull(false);
        this.company_name.limitMaxLength(50);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.email_address.setNotNull(false);
        this.email_address.limitMaxLength(50);
        this.add_dest_type_pc.setNotNull(false);
        this.add_dest_type_pc.limitMaxLength(1);
        this.add_dest_type_cellphone.setNotNull(false);
        this.add_dest_type_cellphone.limitMaxLength(1);
        this.subject_type.setNotNull(true);
        this.subject_type.limitMaxLength(1);
        this.custom_subject.setNotNull(true);
        this.custom_subject.limitMaxLength(50);
        this.note_stat.setNotNull(true);
        this.note_stat.limitMaxLength(1);
        this.message.setNotNull(false);
        this.message.limitMaxLength(1000);
        this.accept_date.setNotNull(true);
        this.confirm_date.setNotNull(true);
        this.confirm_date.setValue(Calendar.getInstance().getTime());
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        this.dest_post_id.validate(msgList);
        this.dest_user_id.validate(msgList);
        if (this.dest_user_id.getValue() != null && this.dest_user_id.getValue().equals("all")) {
            if (this.memberList == null || this.memberList.size() <= 1) {
                msgList.add(ALLocalizationUtils.getl10n((String)"NOTE_ALERT_NO_USER_IN_GROUP"));
            }
        } else if (this.memberList == null || this.memberList.size() <= 1) {
            msgList.add(ALLocalizationUtils.getl10n((String)"NOTE_ALERT_NO_COLLECT_USER"));
        }
        this.client_name.validate(msgList);
        this.company_name.validate(msgList);
        boolean emptyTelephone1 = this.telephone1.getValue().equals("");
        boolean emptyTelephone2 = this.telephone2.getValue().equals("");
        boolean emptyTelephone3 = this.telephone3.getValue().equals("");
        if (!(emptyTelephone1 && emptyTelephone2 && emptyTelephone3 || this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy) && !emptyTelephone1 && !emptyTelephone2 && !emptyTelephone3)) {
            msgList.add(ALLocalizationUtils.getl10n((String)"NOTE_ALERT_NO_CLIENT_PHONE_NUMBER"));
        }
        this.email_address.validate(msgList);
        if (this.email_address.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.email_address.getValue())) {
            msgList.add(ALLocalizationUtils.getl10n((String)"NOTE_ALERT_NO_CLIENT_EMEIL"));
        }
        this.add_dest_type_pc.validate(msgList);
        this.add_dest_type_cellphone.validate(msgList);
        if ("0".equals(this.subject_type.getValue())) {
            this.custom_subject.validate(msgList);
        } else {
            this.subject_type.validate(msgList);
        }
        this.message.validate(msgList);
        this.accept_date.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        EipTNote note;
        int add_dest_type_int = 0;
        try {
            Date nowDate = Calendar.getInstance().getTime();
            note = (EipTNote)Database.create(EipTNote.class);
            note.setOwnerId(Integer.toString(ALEipUtils.getUserId((RunData)rundata)));
            note.setClientName(this.client_name.getValue());
            note.setCompanyName(this.company_name.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                note.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                note.setTelephone("");
            }
            note.setEmailAddress(this.email_address.getValue());
            String add_dest_type_pc_str = this.add_dest_type_pc.getValue();
            String add_dest_type_cellphone_str = this.add_dest_type_cellphone.getValue();
            if (add_dest_type_pc_str != null && !add_dest_type_pc_str.equals("")) {
                ++add_dest_type_int;
            }
            if (add_dest_type_cellphone_str != null && !add_dest_type_cellphone_str.equals("")) {
                add_dest_type_int += 2;
            }
            note.setAddDestType(Integer.toString(add_dest_type_int));
            note.setSubjectType(this.subject_type.getValue());
            if ("0".equals(this.subject_type.getValue())) {
                note.setCustomSubject(this.custom_subject.getValue());
            }
            note.setMessage(this.message.getValue());
            note.setAcceptDate(this.accept_date.getValue());
            note.setCreateDate(nowDate);
            note.setUpdateDate(nowDate);
            if (this.memberList != null) {
                for (ALEipUser aLEipUser : this.memberList) {
                    this.saveNoteMap(rundata, note, aLEipUser.getUserId().toString(), "1");
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(note.getNoteId().intValue(), 140, NoteUtils.getNoteSubject(note));
            ArrayList<String> recipients = new ArrayList<String>();
            if (this.memberList != null) {
                for (ALEipUser user3 : this.memberList) {
                    if (user3.getUserId().getValue() == this.loginUser.getUserId().getValue()) continue;
                    recipients.add(user3.getName().getValue());
                }
            }
            ALEipUser aLEipUser = ALEipUtils.getALEipUser((RunData)rundata);
            NoteUtils.sendNoteActivity(note, aLEipUser.getName().getValue(), recipients);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"note", (Throwable)ex);
            return false;
        }
        if (add_dest_type_int > 0) {
            try {
                String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"NOTE_NOTE");
                List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)((int)this.loginUser.getUserId().getValue()), (boolean)false);
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr aLEipUserAddr : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(aLEipUserAddr);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(this.createMsgForPc(rundata, note, this.memberList));
                    message.setCellularBody(this.createMsgForCellPhone(rundata, note, this.memberList));
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, add_dest_type_int));
                HashSet<String> tempMsgList = new HashSet<String>();
                tempMsgList.addAll(msgList);
                msgList.clear();
                msgList.addAll(tempMsgList);
            }
            catch (Exception ex) {
                msgList.add(ALLocalizationUtils.getl10n((String)"NOTE_DONOT_SEND_MAIL"));
                logger.error((Object)"note", (Throwable)ex);
                return false;
            }
        }
        return msgList.size() == 0;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTNoteMap map = NoteUtils.getEipTNoteMap(rundata, context, this.getSelectQueryForDelete(rundata, context));
            if (map == null) {
                return false;
            }
            ArrayList<String> delNoteIdList = new ArrayList<String>();
            delNoteIdList.add(map.getEipTNote().getNoteId().toString());
            return NoteUtils.deleteNotes(rundata, context, delNoteIdList, msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return false;
        }
    }

    private SelectQuery<EipTNoteMap> getSelectQueryForDelete(RunData rundata, Context context) {
        String userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        SelectQuery query = Database.query(EipTNoteMap.class);
        if ("received_notes".equals(NoteUtils.getCurrentTab(rundata, context))) {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)userId);
            query.setQualifier(exp2);
        } else {
            Expression exp = ExpressionFactory.matchExp((String)"eipTNote.ownerId", (Object)userId);
            query.setQualifier(exp);
        }
        return query;
    }

    public void initField() {
        this.note_id = new ALNumberField();
        this.note_id.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_ID"));
        this.src_user_id = new ALStringField();
        this.src_user_id.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_SRC_USER"));
        this.src_user_id.setTrim(true);
        this.dest_user_id = new ALStringField();
        this.dest_user_id.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_TO"));
        this.dest_user_id.setTrim(true);
        this.dest_user_name = new ALStringField();
        this.dest_user_name.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_SEND_NOTE_TO_NAME"));
        this.dest_user_name.setTrim(true);
        this.dest_post_id = new ALNumberField();
        this.dest_post_id.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_SEND_NOTE_POSITION_ID"));
        this.client_name = new ALStringField();
        this.client_name.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLIENT_NAME"));
        this.client_name.setTrim(true);
        this.company_name = new ALStringField();
        this.company_name.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLIENT_CAMPANY"));
        this.company_name.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLIENT_CELLILAR_PHONE"));
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLIENT_CELLILAR_PHONE"));
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLIENT_CELLILAR_PHONE"));
        this.telephone3.setTrim(true);
        this.email_address = new ALStringField();
        this.email_address.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLIENT_EMAIL"));
        this.email_address.setTrim(true);
        this.add_dest_type_pc = new ALStringField();
        this.add_dest_type_pc.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_MAILINFORM_POSITION"));
        this.add_dest_type_pc.setTrim(true);
        this.add_dest_type_cellphone = new ALStringField();
        this.add_dest_type_cellphone.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_MAILINFORM_POSITION"));
        this.add_dest_type_cellphone.setTrim(true);
        this.subject_type = new ALStringField();
        this.subject_type.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_SUBJECT"));
        this.subject_type.setTrim(true);
        this.custom_subject = new ALStringField();
        this.custom_subject.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_SUBJECT"));
        this.custom_subject.setTrim(true);
        this.note_stat = new ALStringField();
        this.note_stat.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_STATE"));
        this.note_stat.setTrim(true);
        this.message = new ALStringField();
        this.message.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_MESSAGE"));
        this.message.setTrim(false);
        this.accept_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.accept_date.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CLERK_TIME"));
        this.confirm_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.confirm_date.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_CHECK_TIME"));
        this.create_date = new ALDateTimeField("yyyy/MM/dd");
        this.create_date.setFieldName(ALLocalizationUtils.getl10n((String)"COMMON_CREATE_DATE"));
        this.update_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.update_date.setFieldName(ALLocalizationUtils.getl10n((String)"COMMON_UPDATE_DATE"));
        this.currentYear = Calendar.getInstance().get(1);
        this.view_type = new ALStringField();
        this.view_type.setFieldName(ALLocalizationUtils.getl10n((String)"NOTE_EXPRESS_TYPE"));
        this.view_type.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean success = super.setFormData(rundata, context, msgList);
        this.src_user_id.setValue(Integer.toString(ALEipUtils.getUserId((RunData)rundata)));
        if (this.accept_date.toString().equals("")) {
            this.accept_date.setValue(Calendar.getInstance().getTime());
        }
        if (this.subject_type.getValue() == null) {
            this.subject_type.setValue("3");
        }
        if (this.dest_user_id.getValue() == null || this.dest_user_id.getValue().equals("") || this.dest_user_id.getValue().equals("all")) {
            if (this.target_group_name == null || this.target_group_name.equals("") || this.target_group_name.equals("all")) {
                this.memberList = this.getUsers("LoginUser");
            } else {
                this.memberList = this.getUsers(this.target_group_name);
                if (!this.containtsUser(this.memberList, this.loginUser)) {
                    this.memberList.add(this.loginUser);
                }
            }
        } else {
            Integer destid = Integer.valueOf(this.dest_user_id.getValue());
            this.memberList = new ArrayList<ALEipUser>();
            this.memberList.add(ALEipUtils.getALEipUser((int)destid));
            if (!this.containtsUser(this.memberList, this.loginUser)) {
                this.memberList.add(this.loginUser);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMsgForPc(RunData rundata, EipTNote note, List<ALEipUser> memberList) throws ALDBErrorException {
        block27: {
            String string;
            boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
            ALEipUser loginUser = null;
            ALBaseUser user = null;
            StringWriter out = null;
            try {
                loginUser = ALEipUtils.getALEipUser((RunData)rundata);
                user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
            }
            catch (Exception e) {
                return "";
            }
            try {
                VelocityService service = (VelocityService)((TurbineServices)TurbineServices.getInstance()).getService("VelocityService");
                Context context = service.getContext();
                context.put("clientName", (Object)note.getClientName());
                context.put("companyName", (Object)note.getCompanyName());
                ALDateTimeField alDateTimeField = new ALDateTimeField();
                alDateTimeField.setValue(note.getAcceptDate());
                StringBuffer acceptDate = new StringBuffer();
                acceptDate.append(alDateTimeField.getMonth()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MONTH", (Object[])new Object[0])).append(alDateTimeField.getDay()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_DAY", (Object[])new Object[0])).append(alDateTimeField.getHour()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_HOUR", (Object[])new Object[0])).append(alDateTimeField.getMinute()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MINUTE", (Object[])new Object[0]));
                context.put("acceptDate", (Object)acceptDate);
                String subjectType = note.getSubjectType();
                String subject = "";
                if ("0".equals(subjectType)) {
                    subject = note.getCustomSubject();
                } else if ("1".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN");
                } else if ("2".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_BACK");
                } else if ("3".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_TELL_ME");
                } else if ("4".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_TAKE_A_MESSAGE");
                }
                context.put("subjectType", (Object)subject);
                context.put("clientName", (Object)note.getClientName());
                context.put("companyName", (Object)note.getCompanyName());
                context.put("telephone", (Object)note.getTelephone());
                context.put("emailAddress", (Object)note.getEmailAddress());
                context.put("message", (Object)note.getMessage());
                context.put("loginUser", (Object)loginUser.getAliasName().toString());
                context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
                context.put("email", (Object)user.getEmail());
                context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
                context.put("enableAsp", (Object)enableAsp);
                context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
                context.put("localurl", (Object)ALMailUtils.getLocalurl());
                CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
                String lang = locService.getLocale(rundata).getLanguage();
                out = new StringWriter();
                if (lang != null && lang.equals("ja")) {
                    service.handleRequest(context, "portlets/mail/" + lang + "/note-notification-mail.vm", (Writer)out);
                    out.flush();
                    String string2 = out.toString();
                    return string2;
                }
                service.handleRequest(context, "portlets/mail/note-notification-mail.vm", (Writer)out);
                out.flush();
                string = out.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                break block27;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMsgForCellPhone(RunData rundata, EipTNote note, List<ALEipUser> memberList) throws ALDBErrorException {
        block27: {
            String string;
            boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
            ALEipUser loginUser = null;
            ALBaseUser user = null;
            StringWriter out = null;
            try {
                loginUser = ALEipUtils.getALEipUser((RunData)rundata);
                user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
            }
            catch (Exception e) {
                return "";
            }
            try {
                VelocityService service = (VelocityService)((TurbineServices)TurbineServices.getInstance()).getService("VelocityService");
                Context context = service.getContext();
                context.put("clientName", (Object)note.getClientName());
                context.put("companyName", (Object)note.getCompanyName());
                ALDateTimeField alDateTimeField = new ALDateTimeField();
                alDateTimeField.setValue(note.getAcceptDate());
                StringBuffer acceptDate = new StringBuffer();
                acceptDate.append(alDateTimeField.getMonth()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MONTH", (Object[])new Object[0])).append(alDateTimeField.getDay()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_DAY", (Object[])new Object[0])).append(alDateTimeField.getHour()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_HOUR", (Object[])new Object[0])).append(alDateTimeField.getMinute()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MINUTE", (Object[])new Object[0]));
                context.put("acceptDate", (Object)acceptDate);
                String subjectType = note.getSubjectType();
                String subject = "";
                if ("0".equals(subjectType)) {
                    subject = note.getCustomSubject();
                } else if ("1".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN");
                } else if ("2".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_BACK");
                } else if ("3".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_TELL_ME");
                } else if ("4".equals(subjectType)) {
                    subject = ALLocalizationUtils.getl10n((String)"NOTE_TAKE_A_MESSAGE");
                }
                context.put("subjectType", (Object)subject);
                context.put("clientName", (Object)note.getClientName());
                context.put("companyName", (Object)note.getCompanyName());
                context.put("telephone", (Object)note.getTelephone());
                context.put("emailAddress", (Object)note.getEmailAddress());
                context.put("message", (Object)note.getMessage());
                context.put("loginUser", (Object)loginUser.getAliasName().toString());
                context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
                context.put("email", (Object)user.getEmail());
                context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
                context.put("enableAsp", (Object)enableAsp);
                context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
                context.put("localurl", (Object)ALMailUtils.getLocalurl());
                CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
                String lang = locService.getLocale(rundata).getLanguage();
                out = new StringWriter();
                if (lang != null && lang.equals("ja")) {
                    service.handleRequest(context, "portlets/mail/" + lang + "/note-notification-mail.vm", (Writer)out);
                    out.flush();
                    String string2 = out.toString();
                    return string2;
                }
                service.handleRequest(context, "portlets/mail/note-notification-mail.vm", (Writer)out);
                out.flush();
                string = out.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                break block27;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            return string;
        }
        return null;
    }

    private void saveNoteMap(RunData rundata, EipTNote note, String userId, String stat) throws ALDBErrorException {
        EipTNoteMap map = (EipTNoteMap)Database.create(EipTNoteMap.class);
        map.setEipTNote(note);
        map.setUserId(userId);
        map.setDelFlg("F");
        map.setNoteStat(stat);
    }

    private boolean containtsUser(List<ALEipUser> list, ALEipUser user) {
        if (user == null || list == null || list.size() <= 0) {
            return false;
        }
        long userid = user.getUserId().getValue();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            user = list.get(i);
            if (user.getUserId().getValue() != userid) continue;
            return true;
        }
        return false;
    }

    public void enableAddDestTypes() {
        this.add_dest_type_pc.setValue("1");
        this.add_dest_type_cellphone.setValue("1");
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public ALDateTimeField getAcceptDate() {
        return this.accept_date;
    }

    public ALStringField getAddDestTypePc() {
        return this.add_dest_type_pc;
    }

    public ALStringField getAddDestTypeCellphone() {
        return this.add_dest_type_cellphone;
    }

    public ALStringField getClientName() {
        return this.client_name;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALDateTimeField getConfirmDate() {
        return this.confirm_date;
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public ALStringField getDestUserId() {
        return this.dest_user_id;
    }

    public ALStringField getEmailAddress() {
        return this.email_address;
    }

    public ALStringField getMessage() {
        return this.message;
    }

    public ALNumberField getNoteId() {
        return this.note_id;
    }

    public ALStringField getSrcUserId() {
        return this.src_user_id;
    }

    public ALStringField getSubjectType() {
        return this.subject_type;
    }

    public ALStringField getCustomSubject() {
        return this.custom_subject;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public ALDateTimeField getUpdateDate() {
        return this.update_date;
    }

    public void setNoteStat(String value) {
        this.note_stat.setValue(value);
    }

    public ALStringField getNoteStat() {
        return this.note_stat;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public ALStringField getViewType() {
        return this.view_type;
    }

    public void setViewType(String string) {
        this.view_type.setValue(string);
    }

    public ALStringField getDestUserName() {
        return this.dest_user_name;
    }

    public ALNumberField getDestPostId() {
        return this.dest_post_id;
    }

    public String getUserId(String userName) {
        return NoteUtils.getUserId(userName);
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public int getMsgType() {
        return 0;
    }
}

