/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.NoteGroupResultData;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteGroupSelectData
extends ALAbstractSelectData<TurbineUser, TurbineUser>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteGroupSelectData.class.getName());
    private String currentTab;
    private String userId = null;
    private String userAliasName = null;
    private List<ALEipGroup> myGroupList = null;
    private int unreadReceivedNotesAllSum = 0;
    private int newNoteAllSum = 0;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        super.init(action, rundata, context);
        try {
            VelocityPortlet portlet;
            String groupName;
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if ((filter == null || filter.equals("")) && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3b-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"group");
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Exception", (Throwable)ex);
        }
    }

    protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {
        this.setCurrentTab(rundata, context);
        try {
            this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            this.userAliasName = ALEipUtils.getALEipUser((RunData)rundata).getAliasName().toString();
            NoteUtils.getTargetGroupName(rundata, context);
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            for (ALEipGroup group : myGroups) {
                this.myGroupList.add(group);
            }
            List list = NoteUtils.getSelectQueryNoteList(rundata, context).fetchList();
            if (list != null && list.size() > 0) {
                String stat = null;
                for (EipTNoteMap map : list) {
                    stat = map.getNoteStat();
                    if ("1".equals(stat)) {
                        ++this.newNoteAllSum;
                        continue;
                    }
                    if (!"2".equals(stat)) continue;
                    ++this.unreadReceivedNotesAllSum;
                }
            }
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
            if (filter == null || filter_type == null || filter.equals("")) {
                return new ResultList(new ArrayList());
            }
            SelectQuery<TurbineUser> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    protected TurbineUser selectDetail(RunData rundata, Context context) {
        this.setCurrentTab(rundata, context);
        return null;
    }

    protected Object getResultData(TurbineUser user) {
        try {
            NoteGroupResultData rd = new NoteGroupResultData();
            rd.initField();
            rd.setUserId(user.getUserId());
            rd.setUserName(user.getLastName() + " " + user.getFirstName());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(TurbineUser obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("src_user", "lastNameKana");
        map.putValue("group", "turbineUserGroupRole.turbineGroup.groupName");
        map.putValue("userposition", "eipMUserPosition.position");
        return map;
    }

    private SelectQuery<TurbineUser> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(TurbineUser.class);
        Expression exp11 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp12 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp13 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.setQualifier(exp11.andExp(exp12).andExp(exp13));
        Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.userId));
        query.andQualifier(exp3);
        return this.buildSelectQueryForFilter((SelectQuery<TurbineUser>)query, rundata, context);
    }

    protected SelectQuery<TurbineUser> buildSelectQueryForFilter(SelectQuery<TurbineUser> query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    private void setCurrentTab(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
            this.currentTab = "received_notes";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserAliasName() {
        return this.userAliasName;
    }

    public String getUserAliasNameText() {
        return ALLocalizationUtils.getl10nFormat((String)"NOTE_USER_ALIAS_NAME_TEXT", (Object[])new Object[]{this.userAliasName.toString()});
    }

    public int getNewNoteAllSum() {
        return this.newNoteAllSum;
    }

    public String getNewNoteAllSumText() {
        return ALLocalizationUtils.getl10nFormat((String)"NOTE_NEW_NOTE_ALL_SUM_TEXT", (Object[])new Object[]{this.newNoteAllSum});
    }

    public int getUnreadReceivedNotesAllSum() {
        return this.unreadReceivedNotesAllSum;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }
}

