/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.sql.Connection;
import org.apache.commons.configuration.Configuration;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Disposable;
import org.apache.stratum.lifecycle.Initializable;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueInstance;
import org.apache.torque.adapter.DB;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;

public class Torque
implements Initializable,
Configurable,
Disposable {
    public static final String DATABASE_DEFAULT = "database.default";
    public static final String MANAGER_PREFIX = "managed_class.";
    public static final String MANAGER_SUFFIX = ".manager";
    public static final String CACHE_KEY = "manager.useCache";
    private static TorqueInstance torqueSingleton = null;
    private Configuration memberConfig = null;

    public static TorqueInstance getInstance() {
        if (torqueSingleton == null) {
            torqueSingleton = new TorqueInstance();
        }
        return torqueSingleton;
    }

    public static void init(String configFile) throws TorqueException {
        Torque.getInstance().init(configFile);
    }

    public static void init(Configuration conf) throws TorqueException {
        Torque.getInstance().init(conf);
    }

    public static boolean isInit() {
        return Torque.getInstance().isInit();
    }

    public static void setConfiguration(Configuration conf) {
        Torque.getInstance().setConfiguration(conf);
    }

    public static Configuration getConfiguration() {
        return Torque.getInstance().getConfiguration();
    }

    public static AbstractBaseManager getManager(String name) {
        return Torque.getInstance().getManager(name);
    }

    public static AbstractBaseManager getManager(String name, String defaultClassName) {
        return Torque.getInstance().getManager(name, defaultClassName);
    }

    public static void shutdown() {
        Torque.getInstance().shutdown();
    }

    public static DatabaseMap getDatabaseMap() throws TorqueException {
        return Torque.getInstance().getDatabaseMap();
    }

    public static DatabaseMap getDatabaseMap(String name) throws TorqueException {
        return Torque.getInstance().getDatabaseMap(name);
    }

    public static void registerMapBuilder(String className) {
        Torque.getInstance().registerMapBuilder(className);
    }

    public static Connection getConnection() throws TorqueException {
        return Torque.getInstance().getConnection();
    }

    public static Connection getConnection(String name) throws TorqueException {
        return Torque.getInstance().getConnection(name);
    }

    public static Connection getConnection(String name, String username, String password) throws TorqueException {
        return Torque.getInstance().getConnection(name, username, password);
    }

    public static DB getDB(String name) throws TorqueException {
        return Torque.getInstance().getDB(name);
    }

    public static String getDefaultDB() {
        return Torque.getInstance().getDefaultDB();
    }

    public static void closeConnection(Connection con) {
        Torque.getInstance().closeConnection(con);
    }

    public void configure(Configuration conf) throws TorqueException {
        this.memberConfig = conf;
    }

    public void initialize() throws TorqueException {
        Torque.getInstance().init(this.memberConfig);
    }

    public void dispose() {
        Torque.getInstance().shutdown();
    }
}

