/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.navigations;

import freemarker.template.SimpleHash;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.turbine.modules.navigations.TemplateNavigation;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.freemarker.FreeMarkerService;
import org.apache.turbine.util.RunData;

public class BaseFreeMarkerNavigation
extends TemplateNavigation {
    protected void doBuildTemplate(RunData data, SimpleHash context) throws Exception {
    }

    protected void doBuildTemplate(RunData data) throws Exception {
        this.doBuildTemplate(data, this.getContext(data));
    }

    protected SimpleHash getContext(RunData data) {
        SimpleHash context = (SimpleHash)data.getTemplateInfo().getTemplateContext("FREEMARKER_CONTEXT");
        if (context == null) {
            FreeMarkerService fm = (FreeMarkerService)TurbineServices.getInstance().getService("FreeMarkerService");
            context = fm.getContext();
            data.getTemplateInfo().setTemplateContext("FREEMARKER_CONTEXT", context);
        }
        return context;
    }

    public ConcreteElement buildTemplate(RunData data) throws Exception {
        SimpleHash context = this.getContext(data);
        String templateName = data.getTemplateInfo().getNavigationTemplate();
        FreeMarkerService fm = (FreeMarkerService)TurbineServices.getInstance().getService("FreeMarkerService");
        StringElement output = new StringElement();
        output.setFilterState(false);
        output.addElement(fm.handleRequest(context, "navigations/" + templateName, true));
        return output;
    }
}

