/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;

public class IntegerField
extends Field {
    public IntegerField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = new Integer(prop);
        }
        catch (Exception e) {
            Log.error("Could not convert " + prop + " into an Integer. (" + this.name + ")");
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.turbine.services.intake.validator.IntegerValidator";
    }

    protected void doSetValue(ParameterParser pp) {
        if (this.isMultiValued) {
            String[] ss = pp.getStrings(this.getKey());
            int[] ival = new int[ss.length];
            int i = 0;
            while (i < ss.length) {
                ival[i] = Integer.parseInt(ss[i]);
                ++i;
            }
            this.setTestValue(ival);
        } else {
            this.setTestValue(new Integer(pp.getString(this.getKey())));
        }
    }
}

