/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import com.workingdogs.village.Record;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.map.TurbineMapBuilder;

public class JobEntryPeer
extends BasePeer {
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder)BasePeer.getMapBuilder((String)"org.apache.turbine.util.db.map.TurbineMapBuilder");
    private static final String TABLE_NAME = mapBuilder.getTableJobentry();
    public static final String OID = mapBuilder.getJobentry_JobId();
    public static final String SECOND = mapBuilder.getJobentry_Second();
    public static final String MINUTE = mapBuilder.getJobentry_Minute();
    public static final String HOUR = mapBuilder.getJobentry_Hour();
    public static final String WEEKDAY = mapBuilder.getJobentry_Weekday();
    public static final String DAY_OF_MONTH = mapBuilder.getJobentry_DayOfMonth();
    public static final String TASK = mapBuilder.getJobentry_Task();
    public static final String EMAIL = mapBuilder.getJobentry_Email();
    public static final String PROPERTY = mapBuilder.getJobentry_Property();

    public static void doUpdate(Criteria criteria) throws TorqueException {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put((Object)OID, criteria.remove(OID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        JobEntryPeer.addSelectColumns(criteria);
        List rows = BasePeer.doSelect((Criteria)criteria);
        ArrayList<JobEntry> results = new ArrayList<JobEntry>();
        try {
            int i = 0;
            while (i < rows.size()) {
                Record rec = (Record)rows.get(i);
                int oid = rec.getValue(1).asInt();
                int sec = rec.getValue(2).asInt();
                int min = rec.getValue(3).asInt();
                int hr = rec.getValue(4).asInt();
                int wd = rec.getValue(5).asInt();
                int d_m = rec.getValue(6).asInt();
                String task = rec.getValue(7).asString();
                String email = rec.getValue(8).asString();
                byte[] objectData = rec.getValue(9).asBytes();
                Hashtable tempHash = (Hashtable)ObjectUtils.deserialize(objectData);
                JobEntry je = new JobEntry(sec, min, hr, wd, d_m, task);
                je.setPrimaryKey(oid);
                je.setEmail(email);
                je.setProperty(tempHash);
                je.setModified(false);
                results.add(je);
                ++i;
            }
        }
        catch (Exception ex) {
            throw new TorqueException((Throwable)ex);
        }
        return results;
    }

    public static ObjectKey doInsert(Criteria criteria) throws TorqueException {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, Connection dbCon) throws TorqueException {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria, (Connection)dbCon);
    }

    protected static void addSelectColumns(Criteria criteria) throws TorqueException {
        criteria.addSelectColumn(OID).addSelectColumn(SECOND).addSelectColumn(MINUTE).addSelectColumn(HOUR).addSelectColumn(WEEKDAY).addSelectColumn(DAY_OF_MONTH).addSelectColumn(TASK).addSelectColumn(EMAIL).addSelectColumn(PROPERTY);
    }

    public static JobEntry getJob(int oid) throws Exception {
        JobEntry je = null;
        Criteria c = new Criteria(9);
        c.add(OID, (Object)new Integer(oid));
        List results = JobEntryPeer.doSelect(c);
        if (results != null) {
            je = (JobEntry)results.get(0);
        }
        return je;
    }
}

