/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.services.upload.BaseUploadService;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.upload.FileItem;
import org.apache.turbine.util.upload.MultipartStream;

public class TurbineUploadService
extends BaseUploadService {
    public void parseRequest(HttpServletRequest req, ParameterParser params, String path) throws TurbineException {
        String contentType = req.getHeader("Content-type");
        if (!contentType.startsWith("multipart/form-data")) {
            throw new TurbineException("the request doesn't contain a multipart/form-data stream");
        }
        int requestSize = req.getContentLength();
        if (requestSize == -1) {
            throw new TurbineException("the request was rejected because it's size is unknown");
        }
        if (requestSize > TurbineUpload.getSizeMax()) {
            throw new TurbineException("the request was rejected because it's size exceeds allowed range");
        }
        try {
            byte[] boundary = contentType.substring(contentType.indexOf("boundary=") + 9).getBytes();
            ServletInputStream input = req.getInputStream();
            MultipartStream multi = new MultipartStream((InputStream)input, boundary);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    FileItem item;
                    String subContentType = this.getHeader(headers, "Content-type");
                    if (subContentType != null && subContentType.startsWith("multipart/mixed")) {
                        byte[] subBoundary = subContentType.substring(subContentType.indexOf("boundary=") + 9).getBytes();
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                Object var18_20;
                                FileItem item2 = this.createItem(path, headers, requestSize);
                                OutputStream os = item2.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                    var18_20 = null;
                                }
                                catch (Throwable throwable) {
                                    var18_20 = null;
                                    os.close();
                                    throw throwable;
                                }
                                os.close();
                                params.append(this.getFieldName(headers), item2);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else if (this.getFileName(headers) != null) {
                        Object var20_21;
                        item = this.createItem(path, headers, requestSize);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                            var20_21 = null;
                        }
                        catch (Throwable throwable) {
                            var20_21 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                        params.append(this.getFieldName(headers), item);
                    } else {
                        Object var22_22;
                        item = this.createItem(path, headers, requestSize);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                            var22_22 = null;
                        }
                        catch (Throwable throwable) {
                            var22_22 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                        params.append(this.getFieldName(headers), new String(item.get()));
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            throw new TurbineException("Processing of multipart/form-data request failed", e);
        }
    }

    protected String getFileName(Map headers) {
        String fileName = null;
        String cd = this.getHeader(headers, "Content-disposition");
        if (cd.startsWith("form-data") || cd.startsWith("attachment")) {
            String str;
            int start = cd.indexOf("filename=\"");
            int end = cd.indexOf(34, start + 10);
            if (start != -1 && end != -1 && start + 10 != end && (str = cd.substring(start + 10, end).trim()).length() > 0) {
                fileName = str;
            }
        }
        return fileName;
    }

    protected String getFieldName(Map headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, "Content-disposition");
        if (cd != null && cd.startsWith("form-data")) {
            int start = cd.indexOf("name=\"");
            int end = cd.indexOf(34, start + 6);
            if (start != -1 && end != -1) {
                fieldName = cd.substring(start + 6, end);
            }
        }
        return fieldName;
    }

    protected FileItem createItem(String path, Map headers, int requestSize) {
        return FileItem.newInstance(path, this.getFileName(headers), this.getHeader(headers, "Content-type"), requestSize);
    }

    protected Map parseHeaders(String headerPart) {
        HashMap<String, String> headers = new HashMap<String, String>();
        char[] buffer = new char[1024];
        boolean done = false;
        int j = 0;
        try {
            while (!done) {
                int i = 0;
                while (i < 2 || buffer[i - 2] != '\r' || buffer[i - 1] != '\n') {
                    buffer[i++] = headerPart.charAt(j++);
                }
                String header = new String(buffer, 0, i - 2);
                if (header.equals("")) {
                    done = true;
                    continue;
                }
                if (header.indexOf(58) == -1) continue;
                String headerName = header.substring(0, header.indexOf(58)).trim().toLowerCase();
                String headerValue = header.substring(header.indexOf(58) + 1).trim();
                if (this.getHeader(headers, headerName) != null) {
                    headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
                    continue;
                }
                headers.put(headerName, headerValue);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return headers;
    }

    protected final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }
}

