/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.webmacro;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.webmacro.WebMacroService;
import org.apache.turbine.util.ContentURI;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.template.TemplateLink;
import org.apache.turbine.util.template.TemplatePageAttributes;
import org.apache.turbine.util.webmacro.WebMacroFormatter;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.InitException;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.WM;
import org.webmacro.WebMacro;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.ThreadScheduler;

public class TurbineWebMacroService
extends BaseTemplateEngineService
implements WebMacroService {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private WebMacro wm = null;
    private WebContext wcPrototype = null;
    private Broker broker = null;
    private String[] templatePaths = null;
    private String WMProperties = null;
    private String WMTemplateProvider = null;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig unused) throws InitializationException {
        try {
            this.initWebMacro();
            this.initWebContext();
            this.registerConfiguration("wm");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("WebMacroService failed to initialize", e);
        }
    }

    public void shutdown() {
        this.wm.destroy();
        ThreadScheduler.stop();
    }

    public WebContext getContext() {
        return new WebContext(this.broker);
    }

    public WebContext getContext(RunData data) {
        WebContext newWC = this.wcPrototype.newInstance(data.getRequest(), data.getResponse());
        newWC.put((Object)"data", (Object)data);
        newWC.put((Object)"link", (Object)new TemplateLink(data));
        newWC.put((Object)"page", (Object)new TemplatePageAttributes(data));
        newWC.put((Object)"formatter", (Object)new WebMacroFormatter((Context)newWC));
        newWC.put((Object)"content", (Object)new ContentURI(data));
        return newWC;
    }

    public String handleRequest(WebContext wc, String filename) throws TurbineException {
        String results = null;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            FastWriter fw = new FastWriter((OutputStream)bytes, DEFAULT_ENCODING);
            this.handleRequest(wc, filename, fw);
            fw.flush();
            results = bytes.toString(DEFAULT_ENCODING);
        }
        catch (Exception e) {
            throw new TurbineException("An error occurred while rendering template: " + filename, e);
        }
        return results;
    }

    public void handleRequest(WebContext wc, String filename, OutputStream out) throws Exception {
        this.handleRequest(wc, filename, new FastWriter(out, DEFAULT_ENCODING));
    }

    public void handleRequest(WebContext wc, String filename, FastWriter writer) throws Exception {
        Template template = this.getTemplate(filename);
        template.write(writer, (Context)wc);
    }

    public Template getTemplate(String filename) throws NotFoundException {
        return this.wm.getTemplate(filename);
    }

    private void initWebMacro() throws InitException, InitializationException {
        Configuration config = this.getConfiguration();
        this.templatePaths = config.getStringArray("templates");
        this.templatePaths = TurbineTemplate.translateTemplatePaths(this.templatePaths);
        this.WMTemplateProvider = config.getString("templates.provider", null);
        this.WMProperties = config.getString("properties");
        if (this.WMProperties != null) {
            this.WMProperties = TurbineServlet.getRealPath(this.WMProperties);
            this.wm = new WM(this.WMProperties);
        } else {
            this.wm = new WM();
        }
        this.broker = this.wm.getBroker();
        try {
            ResourceBroker resourceBroker = (ResourceBroker)this.broker;
            try {
                Log.debug("Loading TurbineTemplateProvider");
                Class<?> c = Class.forName(this.WMTemplateProvider);
                ResourceProvider provider = (ResourceProvider)c.newInstance();
                Log.debug("Registering TurbineTemplateProvider with WebMacro");
                resourceBroker.join(provider);
            }
            catch (Exception e) {
                throw new TurbineException("Unable to register TurbineTemplateProvider", e);
            }
        }
        catch (Exception e) {
            throw new InitializationException("Failed to set up WebMacro templates", e);
        }
    }

    private void initWebContext() throws InitException {
        this.wcPrototype = this.getContext();
        if (this.wcPrototype == null) {
            throw new InitException("Unable to create WebContext prototype");
        }
    }

    public boolean templateExists(String template) {
        return TurbineTemplate.templateExists(template, this.templatePaths);
    }
}

