/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.xmlrpc.XmlRpcService;
import org.apache.turbine.services.xmlrpc.util.FileTransfer;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.TurbineException;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcServer;
import org.apache.xmlrpc.secure.SecureWebServer;

public class TurbineXmlRpcService
extends TurbineBaseService
implements XmlRpcService {
    protected boolean isModernVersion = false;
    protected WebServer webserver = null;
    protected XmlRpcServer server = null;
    private InetAddress address = null;
    private XmlRpcClient client = null;
    protected int port = 0;

    public void init(ServletConfig config) throws InitializationException {
        try {
            this.server = new XmlRpcServer();
            Configuration secureServerOptions = this.getConfiguration().subset("secure.server.option");
            this.setSystemPropertiesFromConfiguration(secureServerOptions);
            String addr = this.getConfiguration().getString("address", null);
            this.port = this.getConfiguration().getInt("port", 0);
            if (this.port != 0) {
                if (addr != null && addr.length() > 0) {
                    try {
                        this.address = InetAddress.getByName(addr);
                    }
                    catch (UnknownHostException useDefault) {
                        this.address = null;
                    }
                }
                this.webserver = this.getConfiguration().getBoolean("secure.server", false) ? new SecureWebServer(this.port, this.address) : new WebServer(this.port);
            }
            String saxParserClass = this.getConfiguration().getString("parser", "org.apache.xerces.parsers.SAXParser");
            XmlRpc.setDriver((String)saxParserClass);
            Iterator keys = this.getConfiguration().getKeys("handler");
            while (keys.hasNext()) {
                String handler = (String)keys.next();
                String handlerName = handler.substring(handler.indexOf(".") + 1);
                String handlerClass = this.getConfiguration().getString(handler);
                this.registerHandler(handlerName, handlerClass);
            }
            boolean stateOfParanoia = this.getConfiguration().getBoolean("paranoid", false);
            if (stateOfParanoia) {
                this.webserver.setParanoid(stateOfParanoia);
                Log.info("XmlRpcService: Operating in a state of paranoia");
                Vector acceptedClients = this.getConfiguration().getVector("acceptClient");
                int i = 0;
                while (i < acceptedClients.size()) {
                    String acceptClient = (String)acceptedClients.get(i);
                    if (acceptClient != null && !acceptClient.equals("")) {
                        this.webserver.acceptClient(acceptClient);
                        Log.info("XmlRpcService: Accepting client -> " + acceptClient);
                    }
                    ++i;
                }
                Vector deniedClients = this.getConfiguration().getVector("denyClient");
                int i2 = 0;
                while (i2 < deniedClients.size()) {
                    String denyClient = (String)deniedClients.get(i2);
                    if (denyClient != null && !denyClient.equals("")) {
                        this.webserver.denyClient(denyClient);
                        Log.info("XmlRpcService: Denying client -> " + denyClient);
                    }
                    ++i2;
                }
            }
            try {
                Class.forName("org.apache.xmlrpc.XmlRpcRequest");
                this.isModernVersion = true;
                this.webserver.start();
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            Log.debug("XmlRpcService: Using Apache XML-RPC version " + (this.isModernVersion ? "greater than 1.1" : "1.1 or lower"));
        }
        catch (Exception e) {
            throw new InitializationException("XMLRPCService failed to initialize", e);
        }
        this.setInit(true);
    }

    void setSystemPropertiesFromConfiguration(Configuration configuration) {
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = configuration.getString(key);
            Log.debug("JSSE option: " + key + " => " + value);
            System.setProperty(key, value);
        }
    }

    public void registerHandler(Object handler) throws XmlRpcException, IOException {
        this.registerHandler("$default", handler);
    }

    public void registerHandler(String handlerName, Object handler) throws XmlRpcException, IOException {
        if (this.webserver != null) {
            this.webserver.addHandler(handlerName, handler);
        }
        this.server.addHandler(handlerName, handler);
    }

    public void registerHandler(String handlerName, String handlerClass) throws TurbineException {
        try {
            Object handler = Class.forName(handlerClass).newInstance();
            if (this.webserver != null) {
                this.webserver.addHandler(handlerName, handler);
            }
            this.server.addHandler(handlerName, handler);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (Throwable t) {
            throw new TurbineException("Failed to instantiate " + handlerClass, t);
        }
    }

    public void unregisterHandler(String handlerName) {
        if (this.webserver != null) {
            this.webserver.removeHandler(handlerName);
        }
        this.server.removeHandler(handlerName);
    }

    public byte[] handleRequest(InputStream is) {
        return this.server.execute(is);
    }

    public byte[] handleRequest(InputStream is, String user, String password) {
        return this.server.execute(is, user, password);
    }

    public Object executeRpc(URL url, String methodName, Vector params) throws TurbineException {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new TurbineException("XML-RPC call failed", e);
        }
    }

    public Object executeAuthenticatedRpc(URL url, String username, String password, String methodName, Vector params) throws TurbineException {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            client.setBasicAuthentication(username, password);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new TurbineException("XML-RPC call failed", e);
        }
    }

    public void send(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        FileTransfer.send(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void send(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        FileTransfer.send(serverURL, username, password, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void get(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        FileTransfer.get(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void get(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        FileTransfer.get(serverURL, username, password, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public void remove(String serverURL, String sourceLocationProperty, String sourceFileName) throws Exception {
        FileTransfer.remove(serverURL, sourceLocationProperty, sourceFileName);
    }

    public void remove(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName) throws Exception {
        FileTransfer.remove(serverURL, username, password, sourceLocationProperty, sourceFileName);
    }

    public void setParanoid(boolean state) {
        this.webserver.setParanoid(state);
    }

    public void acceptClient(String address) {
        this.webserver.acceptClient(address);
    }

    public void denyClient(String address) {
        this.webserver.denyClient(address);
    }

    public void shutdown() {
        this.webserver.shutdown();
        if (!this.isModernVersion) {
            try {
                Socket interrupt = new Socket(this.address, this.port);
                interrupt.close();
            }
            catch (Exception notShutdown) {
                Log.warn("XmlRpcServiceIt's possible the xmlrpc server was not shutdown: " + notShutdown.getMessage());
            }
        }
        this.setInit(false);
    }
}

