/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Comment;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.Select;

public class TimeSelector {
    public static final String DEFAULT_PREFIX = "TimeSelector";
    public static final String HOUR_SUFFIX = "_hour";
    public static final String MINUTE_SUFFIX = "_minute";
    public static final String SECOND_SUFFIX = "_second";
    public static final String AMPM_SUFFIX = "_ampm";
    public static final int TWELVE_HOUR = 0;
    public static final int TWENTY_FOUR_HOUR = 1;
    private static final NumberFormat nbrFmt = NumberFormat.getInstance();
    private static final int DEFAULT_MINUTE_INTERVAL = 5;
    private static final int DEFAULT_SECOND_INTERVAL = 5;
    private static final int DEFAULT_TIME_FORMAT = 0;
    private int timeFormat = 0;
    private int minuteInterval = 5;
    private int secondInterval = 5;
    private Calendar useDate = null;
    private String selName = null;
    private String onChange = null;
    private boolean onChangeSet = false;
    private boolean showSeconds = false;
    private int setSeconds = 0;

    public TimeSelector() {
        this.selName = DEFAULT_PREFIX;
        this.useDate = Calendar.getInstance();
        this.useDate.setTime(new Date());
    }

    public TimeSelector(String selName, Calendar useDate) {
        this.useDate = useDate;
        this.selName = selName;
    }

    public TimeSelector(String selName) {
        this.selName = selName;
        this.useDate = Calendar.getInstance();
        this.useDate.setTime(new Date());
    }

    public TimeSelector setOnChange(String onChange) {
        if (onChange != null) {
            this.onChange = onChange;
            this.onChangeSet = true;
        } else {
            this.onChange = null;
            this.onChangeSet = false;
        }
        return this;
    }

    public TimeSelector setSeconds(int seconds) {
        this.setSeconds = seconds;
        this.showSeconds = false;
        return this;
    }

    public TimeSelector setMinuteInterval(int minutes) {
        this.minuteInterval = minutes;
        return this;
    }

    public TimeSelector setSecondInterval(int seconds) {
        this.secondInterval = seconds;
        return this;
    }

    public TimeSelector setTimeFormat(int format) {
        this.timeFormat = format;
        return this;
    }

    public TimeSelector setShowSeconds(boolean show) {
        this.showSeconds = show;
        return this;
    }

    public void setSelName(String selName) {
        this.selName = selName;
    }

    public String getSelName() {
        return this.selName;
    }

    public static Select getSecondSelector(String name) {
        return TimeSelector.getSecondSelector(name, Calendar.getInstance());
    }

    public static Select getSecondSelector(String name, Calendar now) {
        return TimeSelector.getSecondSelector(name, Calendar.getInstance(), 5);
    }

    public static Select getSecondSelector(String name, Calendar now, int interval) {
        Select secondSelect = new Select().setName(name);
        int currentSecond = 0;
        while (currentSecond <= 59) {
            Option o = new Option();
            o.addElement(nbrFmt.format(currentSecond));
            o.setValue(currentSecond);
            int nearestSecond = now.get(13) / interval * interval;
            if (nearestSecond == currentSecond) {
                o.setSelected(true);
            }
            secondSelect.addElement((Element)o);
            currentSecond += interval;
        }
        return secondSelect;
    }

    public static Select getMinuteSelector(String name) {
        return TimeSelector.getMinuteSelector(name, Calendar.getInstance());
    }

    public static Select getMinuteSelector(String name, Calendar now) {
        return TimeSelector.getMinuteSelector(name, now, 5);
    }

    public static Select getMinuteSelector(String name, Calendar now, int interval) {
        Select minuteSelect = new Select().setName(name);
        int curMinute = 0;
        while (curMinute <= 59) {
            Option o = new Option();
            o.addElement(nbrFmt.format(curMinute));
            o.setValue(curMinute);
            int nearestMinute = now.get(12) / interval * interval;
            if (nearestMinute == curMinute) {
                o.setSelected(true);
            }
            minuteSelect.addElement((Element)o);
            curMinute += interval;
        }
        return minuteSelect;
    }

    public static Select getHourSelector(String name) {
        return TimeSelector.getHourSelector(name, Calendar.getInstance());
    }

    public static Select getHourSelector(String name, Calendar now) {
        return TimeSelector.getHourSelector(name, Calendar.getInstance(), 0);
    }

    public static Select getHourSelector(String name, Calendar now, int format) {
        Select hourSelect = new Select().setName(name);
        if (format == 1) {
            int currentHour = 0;
            while (currentHour <= 23) {
                Option o = new Option();
                o.addElement(nbrFmt.format(currentHour));
                o.setValue(currentHour);
                if (now.get(11) == currentHour) {
                    o.setSelected(true);
                }
                hourSelect.addElement((Element)o);
                ++currentHour;
            }
        } else {
            int curHour = 1;
            while (curHour <= 12) {
                Option o = new Option();
                o.addElement(nbrFmt.format(curHour));
                o.setValue(curHour);
                if (now.get(9) == 0) {
                    if (now.get(11) == 0 && curHour == 12) {
                        o.setSelected(true);
                    } else if (now.get(11) == curHour) {
                        o.setSelected(true);
                    }
                } else if (now.get(11) == 12 && curHour == 12) {
                    o.setSelected(true);
                } else if (now.get(11) == curHour + 12) {
                    o.setSelected(true);
                }
                hourSelect.addElement((Element)o);
                ++curHour;
            }
        }
        return hourSelect;
    }

    public static Select getAMPMSelector(String name) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        return TimeSelector.getAMPMSelector(name, c);
    }

    public static Select getAMPMSelector(String name, Calendar now) {
        Select ampmSelect = new Select().setName(name);
        Option o = new Option();
        o.addElement("am");
        o.setValue(0);
        if (now.get(9) == 0) {
            o.setSelected(true);
        }
        ampmSelect.addElement((Element)o);
        o = new Option();
        o.addElement("pm");
        o.setValue(1);
        if (now.get(9) == 1) {
            o.setSelected(true);
        }
        ampmSelect.addElement((Element)o);
        return ampmSelect;
    }

    public String output() {
        return this.ecsOutput().toString();
    }

    public String toString() {
        return this.ecsOutput().toString();
    }

    public ElementContainer ecsOutput() {
        if (this.useDate == null) {
            this.useDate = Calendar.getInstance();
            this.useDate.setTime(new Date());
        }
        Input secondSelect = null;
        Select ampmSelect = TimeSelector.getAMPMSelector(this.selName + AMPM_SUFFIX, this.useDate);
        Select hourSelect = TimeSelector.getHourSelector(this.selName + HOUR_SUFFIX, this.useDate, this.timeFormat);
        Select minuteSelect = TimeSelector.getMinuteSelector(this.selName + MINUTE_SUFFIX, this.useDate, this.minuteInterval);
        if (this.showSeconds) {
            Select tmp = TimeSelector.getSecondSelector(this.selName + SECOND_SUFFIX, this.useDate, this.secondInterval);
            if (this.onChangeSet) {
                tmp.setOnChange(this.onChange);
            }
            secondSelect = tmp;
        } else {
            secondSelect = new Input("hidden", this.selName + SECOND_SUFFIX, this.setSeconds);
        }
        if (this.onChangeSet) {
            hourSelect.setOnChange(this.onChange);
            minuteSelect.setOnChange(this.onChange);
            ampmSelect.setOnChange(this.onChange);
        }
        ElementContainer ec = new ElementContainer();
        ec.addElement((Element)new Comment("== BEGIN org.apache.turbine.util.TimeSelector.ecsOutput() =="));
        ec.addElement((Element)hourSelect);
        ec.addElement(":");
        ec.addElement((Element)minuteSelect);
        if (this.showSeconds) {
            ec.addElement(":");
        }
        ec.addElement((Element)secondSelect);
        if (this.timeFormat == 0) {
            ec.addElement((Element)ampmSelect);
        }
        ec.addElement((Element)new Comment("== END org.apache.turbine.util.TimeSelector.ecsOutput() =="));
        return ec;
    }

    static {
        nbrFmt.setMinimumIntegerDigits(2);
        nbrFmt.setMaximumIntegerDigits(2);
    }
}

