/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.validation;

public abstract class InputValidator {
    public static final boolean AllowNullInput = true;
    public static final int NoMaxSize = -1;
    public static final String EmptyArgv = "";
    private static String NullInputError = "Null Input Not Allowed";
    private static String MaxSizeExceededError = "Maximum Size Exceeded";
    private boolean allowNullInput;
    private int maxSize;
    private String argv;

    public InputValidator() {
        this(true, -1, EmptyArgv);
    }

    public InputValidator(boolean allowNullInput, int maxSize, String argv) {
        this.allowNullInput = allowNullInput;
        this.maxSize = maxSize;
        this.argv = argv;
    }

    public void setAllowNullInput(boolean allowNullInput) {
        this.allowNullInput = allowNullInput;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setArgv(String argv) {
        this.argv = argv;
    }

    public boolean isValid(String input) {
        try {
            this.checkInput(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getErrorMessage(String input) {
        try {
            this.checkInput(input);
        }
        catch (Exception e) {
            return e.toString();
        }
        return null;
    }

    public void checkInput(String value) throws Exception {
        int size = 0;
        if (value != null) {
            value = value.trim();
            size = value.length();
        }
        if (!this.allowNullInput && value == null) {
            throw new Exception(NullInputError);
        }
        if (this.maxSize != -1 && size > this.maxSize) {
            throw new Exception(MaxSizeExceededError);
        }
        this.check(value);
    }

    public abstract String getExpectedFormat();

    protected abstract void check(String var1) throws Exception;
}

