/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;

public class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static void dump(Configuration configuration, PrintStream out) {
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!i.hasNext()) continue;
            out.println();
        }
    }

    public static void dump(Configuration configuration, PrintWriter out) {
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!i.hasNext()) continue;
            out.println();
        }
    }

    public static String toString(Configuration configuration) {
        StringWriter writer = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(writer));
        return writer.toString();
    }
}

