/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mygroup;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.mygroup.util.MyGroupUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MyGroupFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MyGroupFormData.class.getName());
    private ALStringField group_alias_name;
    private List<ALEipUser> memberList;
    private List<FacilityResultData> facilityList;
    private List<FacilityResultData> facilityAllList;
    private int userId;
    private String mygroup_name = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.group_alias_name = new ALStringField();
        this.group_alias_name.setFieldName("\u30b0\u30eb\u30fc\u30d7\u540d");
        this.group_alias_name.setTrim(true);
        this.memberList = new ArrayList<ALEipUser>();
        this.facilityList = new ArrayList<FacilityResultData>();
    }

    public void loadFacilityAllList(RunData rundata, Context context) {
        this.facilityAllList = new ArrayList<FacilityResultData>();
        this.facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                Object[] f_id;
                Object[] str;
                if ("update".equals(this.getMode())) {
                    this.mygroup_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
                }
                if ((str = this.getStrList(rundata.getParameters().getStrings("member_to"))) != null && str.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                    query.setQualifier(exp);
                    List list = query.fetchList();
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        TurbineUser record = (TurbineUser)list.get(i);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setName(record.getLoginName());
                        user.setAliasName(record.getFirstName(), record.getLastName());
                        this.memberList.add(user);
                    }
                }
                if ((f_id = this.getStrList(rundata.getParameters().getStrings("facility_to"))) != null && f_id.length > 0) {
                    SelectQuery fquery = Database.query(EipMFacility.class);
                    Expression exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", (Object[])f_id);
                    fquery.setQualifier(exp);
                    List f_list = fquery.fetchList();
                    int f_size = f_list.size();
                    for (int i = 0; i < f_size; ++i) {
                        EipMFacility f_record = (EipMFacility)f_list.get(i);
                        FacilityResultData rd = new FacilityResultData();
                        rd.initField();
                        rd.setFacilityId(f_record.getFacilityId().longValue());
                        rd.setFacilityName(f_record.getFacilityName());
                        this.facilityList.add(rd);
                    }
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                logger.error((Object)"mygroup", (Throwable)ex);
            }
        }
        return res;
    }

    private String[] getStrList(String[] strs) {
        if (strs == null || strs.length <= 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            if (strs[i] == null || strs[i].equals("")) continue;
            list.add(strs[i]);
        }
        String[] new_strs = new String[list.size()];
        new_strs = list.toArray(new_strs);
        return new_strs;
    }

    protected void setValidator() {
        this.group_alias_name.setNotNull(true);
        this.group_alias_name.limitMaxLength(50);
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(TurbineGroup.class);
            if ("insert".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"groupAliasName", (Object)this.group_alias_name.getValue());
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.userId);
                query.setQualifier(exp1);
                query.andQualifier(exp2);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"groupAliasName", (Object)this.group_alias_name.getValue());
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.userId);
                query.setQualifier(exp1);
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.noMatchExp((String)"groupName", (Object)this.mygroup_name);
                query.andQualifier(exp3);
            }
            if (query.fetchList().size() != 0) {
                msgList.add("\u30b0\u30eb\u30fc\u30d7\u540d\u300e <span class='em'>" + this.group_alias_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"mygroup", (Throwable)ex);
            return false;
        }
        this.group_alias_name.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineGroup record = MyGroupUtils.getGroup(rundata, context);
            if (record == null) {
                return false;
            }
            this.group_alias_name.setValue(record.getGroupAliasName());
            this.memberList.addAll(ALEipUtils.getUsers((String)record.getName()));
            this.facilityList.addAll(FacilitiesUtils.getFacilityList((String)record.getName()));
        }
        catch (Exception ex) {
            logger.error((Object)"mygroup", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineGroup group = (TurbineGroup)Database.create(TurbineGroup.class);
            String name = this.group_alias_name.getValue();
            String groupName = new StringBuffer().append(new Date().getTime()).append("_").append(ALEipUtils.getUserId((RunData)rundata)).toString();
            group.setGroupName(groupName);
            group.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            group.setGroupAliasName(name);
            group.setPublicFlag("1");
            JetspeedSecurity.addGroup((Group)group);
            int size = this.memberList.size();
            for (int i = 0; i < size; ++i) {
                JetspeedSecurity.joinGroup((String)this.memberList.get(i).getName().getValue(), (String)group.getGroupName());
            }
            Group jetspeedgroup = JetspeedSecurity.getGroup((String)group.getGroupName());
            int f_size = this.facilityList.size();
            for (int i = 0; i < f_size; ++i) {
                int fid = (int)this.facilityList.get(i).getFacilityId().getValue();
                EipMFacility facility = (EipMFacility)Database.get(EipMFacility.class, (Object)fid);
                this.insertFacilityGroup(facility, (TurbineGroup)jetspeedgroup);
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.parseInt(group.getId()), 270, group.getGroupAliasName());
            ALEipUtils.reloadMygroup((RunData)rundata);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"mygroup", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void insertFacilityGroup(EipMFacility facility, TurbineGroup turbine_group) {
        try {
            EipFacilityGroup fg = (EipFacilityGroup)Database.create(EipFacilityGroup.class);
            fg.setEipMFacility(facility);
            fg.setTurbineGroup(turbine_group);
        }
        catch (Exception e) {
            logger.error((Object)"mygroup", (Throwable)e);
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int i;
            TurbineGroup record = MyGroupUtils.getGroup(rundata, context);
            if (record == null) {
                return false;
            }
            record.setGroupAliasName(this.group_alias_name.getValue());
            JetspeedSecurity.saveGroup((Group)record);
            List users = ALEipUtils.getUsers((String)record.getGroupName());
            int size = users.size();
            for (i = 0; i < size; ++i) {
                JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(i)).getName().getValue(), (String)record.getGroupName());
            }
            size = this.memberList.size();
            for (i = 0; i < size; ++i) {
                JetspeedSecurity.joinGroup((String)this.memberList.get(i).getName().getValue(), (String)record.getGroupName());
            }
            List oldFIdList = FacilitiesUtils.getFacilityIds((String)record.getGroupName());
            if (oldFIdList != null && oldFIdList.size() > 0) {
                SelectQuery query = Database.query(EipFacilityGroup.class);
                Expression exp1 = ExpressionFactory.inDbExp((String)"FACILITY_ID", (Collection)oldFIdList);
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.matchDbExp((String)"turbineGroup.GROUP_ID", (Object)record.getId());
                query.andQualifier(exp2);
                List flist = query.fetchList();
                if (flist != null && flist.size() > 0) {
                    Database.deleteAll((List)flist);
                }
            }
            TurbineGroup tgroup = (TurbineGroup)Database.get(TurbineGroup.class, (Object)Integer.valueOf(record.getId()));
            int f_size = this.facilityList.size();
            for (int i2 = 0; i2 < f_size; ++i2) {
                int fid = (int)this.facilityList.get(i2).getFacilityId().getValue();
                Expression fexp = ExpressionFactory.matchDbExp((String)"FACILITY_ID", (Object)fid);
                SelectQuery fquery = Database.query(EipMFacility.class, (Expression)fexp);
                List list = fquery.fetchList();
                if (list == null || list.size() <= 0) continue;
                EipMFacility facility = (EipMFacility)list.get(0);
                this.insertFacilityGroup(facility, tgroup);
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.parseInt(record.getId()), 270, record.getGroupAliasName());
            ALEipUtils.reloadMygroup((RunData)rundata);
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"mygroup", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"mygroup", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineGroup record = MyGroupUtils.getGroup(rundata, context);
            if (record == null) {
                return false;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)record.getId());
            SelectQuery query = Database.query(EipFacilityGroup.class, (Expression)exp);
            List fglist = query.fetchList();
            if (fglist != null && fglist.size() > 0) {
                Database.deleteAll((List)fglist);
            }
            List users = ALEipUtils.getUsersIncludingN((String)record.getGroupName());
            int size = users.size();
            for (int i = 0; i < size; ++i) {
                JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(i)).getName().getValue(), (String)record.getGroupName());
            }
            JetspeedSecurity.removeGroup((String)record.getGroupName());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.parseInt(record.getId()), 270, record.getGroupAliasName());
            ALEipUtils.reloadMygroup((RunData)rundata);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"mygroup", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getGroupAliasName() {
        return this.group_alias_name;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<FacilityResultData> getFacilityList() {
        return this.facilityList;
    }

    public List<FacilityResultData> getFacilityAllList() {
        return this.facilityAllList;
    }
}

