/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import java.io.Serializable;

public class CachedObject
implements Serializable {
    public static final int DEFAULT = 0;
    public static final int FOREVER = -1;
    private Object contents = null;
    private long defaultage = 1800000L;
    protected long created = 0L;
    private long expires = 0L;
    private boolean stale = false;

    public CachedObject(Object object) {
        this.contents = object;
        this.expires = this.defaultage;
        this.created = System.currentTimeMillis();
    }

    public CachedObject(Object object, long l) {
        if (l == 0L) {
            this.expires = this.defaultage;
        }
        this.contents = object;
        this.expires = l;
        this.created = System.currentTimeMillis();
    }

    public Object getContents() {
        return this.contents;
    }

    public long getCreated() {
        return this.created;
    }

    public long getExpires() {
        return this.expires;
    }

    public synchronized void setStale(boolean bl) {
        this.stale = bl;
    }

    public synchronized boolean getStale() {
        return this.stale;
    }

    public synchronized boolean isStale() {
        if (this.expires == -1L) {
            return false;
        }
        this.setStale(System.currentTimeMillis() - this.created > this.expires);
        return this.getStale();
    }
}

