/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.TurbineIntake;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public class Intake
implements Recyclable {
    public static final String DEFAULT_KEY = "_0";
    private HashMap groups;
    private ValueParser pp;
    HashMap declaredGroups = new HashMap();
    StringBuffer allGroupsSB = new StringBuffer(256);
    StringBuffer groupSB = new StringBuffer(128);
    private Map pullMap;
    Category category = Category.getInstance((String)this.getClass().getName());
    private boolean disposed;

    public Intake() {
        String[] stringArray = TurbineIntake.getGroupNames();
        this.groups = new HashMap((int)(1.25 * (double)stringArray.length + 1.0));
        this.pullMap = new HashMap((int)(1.25 * (double)stringArray.length + 1.0));
        int n = stringArray.length - 1;
        while (n >= 0) {
            this.pullMap.put(stringArray[n], new PullHelper(stringArray[n]));
            --n;
        }
    }

    public void init(ValueParser valueParser) {
        int n;
        this.pp = valueParser;
        String[] stringArray = valueParser.getStrings("intake-grp");
        String[] stringArray2 = null;
        if (stringArray == null || stringArray.length == 0) {
            stringArray2 = TurbineIntake.getGroupNames();
        } else {
            stringArray2 = new String[stringArray.length];
            n = stringArray.length - 1;
            while (n >= 0) {
                stringArray2[n] = TurbineIntake.getGroupName(stringArray[n]);
                --n;
            }
        }
        n = stringArray2.length - 1;
        while (n >= 0) {
            try {
                ArrayList arrayList = TurbineIntake.getGroup(stringArray2[n]).getObjects(valueParser);
                if (arrayList != null) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        Group group = (Group)iterator.next();
                        this.groups.put(group.getObjectKey(), group);
                    }
                }
            }
            catch (Exception exception) {
                this.category.error((Object)exception);
            }
            --n;
        }
    }

    public void addGroupsToParameters(ValueParser valueParser) {
        Iterator iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
                this.declaredGroups.put(group.getIntakeGroupName(), null);
                valueParser.add("intake-grp", group.getGID());
            }
            valueParser.add(group.getGID(), group.getOID());
        }
        this.declaredGroups.clear();
    }

    public String declareGroups() {
        this.allGroupsSB.setLength(0);
        Iterator iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            this.declareGroup((Group)iterator.next(), this.allGroupsSB);
        }
        return this.allGroupsSB.toString();
    }

    public String declareGroup(Group group) {
        this.groupSB.setLength(0);
        this.declareGroup(group, this.groupSB);
        return this.groupSB.toString();
    }

    public void declareGroup(Group group, StringBuffer stringBuffer) {
        if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
            this.declaredGroups.put(group.getIntakeGroupName(), null);
            stringBuffer.append("<input type=\"hidden\" name=\"").append("intake-grp\" value=\"").append(group.getGID()).append("\"/>\n");
        }
        group.appendHtmlFormInput(stringBuffer);
    }

    public void newForm() {
        this.declaredGroups.clear();
        Iterator iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            ((Group)iterator.next()).resetDeclared();
        }
    }

    public PullHelper get(String string) throws Exception {
        return (PullHelper)this.pullMap.get(string);
    }

    public boolean isAllValid() {
        boolean bl = true;
        Iterator iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            bl &= group.isAllValid();
        }
        return bl;
    }

    public Group get(String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception("Intake.get: groupName == null");
        }
        if (string2 == null) {
            throw new Exception("Intake.get: key == null");
        }
        return this.get(string).setKey(string2);
    }

    public Group get(String string, String string2, boolean bl) throws Exception {
        return this.get(string).setKey(string2, bl);
    }

    public void remove(Group group) {
        this.groups.remove(group.getObjectKey());
        group.removeFromRequest();
        TurbineIntake.releaseGroup(group);
    }

    public void removeAll() {
        Object[] objectArray = this.groups.values().toArray();
        int n = objectArray.length - 1;
        while (n >= 0) {
            Group group = (Group)objectArray[n];
            this.remove(group);
            --n;
        }
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        Iterator iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            TurbineIntake.releaseGroup(group);
        }
        this.groups.clear();
        this.declaredGroups.clear();
        this.pp = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public class PullHelper {
        String groupName;

        private PullHelper(String string) {
            this.groupName = string;
        }

        public Group getDefault() throws Exception {
            return this.setKey(Intake.DEFAULT_KEY);
        }

        public Group setKey(String string) throws Exception {
            return this.setKey(string, true);
        }

        public Group setKey(String string, boolean bl) throws Exception {
            Group group = null;
            String string2 = TurbineIntake.getGroupKey(this.groupName) + string;
            if (Intake.this.groups.containsKey(string2)) {
                group = (Group)Intake.this.groups.get(string2);
            } else if (bl) {
                group = TurbineIntake.getGroup(this.groupName);
                Intake.this.groups.put(string2, group);
                group.init(string, Intake.this.pp);
            }
            return group;
        }

        public Group mapTo(Retrievable retrievable) throws Exception {
            Group group = null;
            try {
                String string = TurbineIntake.getGroupKey(this.groupName) + retrievable.getQueryKey();
                if (Intake.this.groups.containsKey(string)) {
                    group = (Group)Intake.this.groups.get(string);
                } else {
                    group = TurbineIntake.getGroup(this.groupName);
                    Intake.this.groups.put(string, group);
                }
                return group.init(retrievable);
            }
            catch (Exception exception) {
                Intake.this.category.error((Object)exception);
                return null;
            }
        }
    }
}

