/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.DateStringValidator;
import org.apache.fulcrum.intake.xmlmodel.XmlField;

public class DateStringField
extends Field {
    private DateFormat df = null;

    public DateStringField(XmlField xmlField, Group group) throws Exception {
        super(xmlField, group);
        if (this.validator == null || !(this.validator instanceof DateStringValidator)) {
            this.df = DateFormat.getInstance();
            this.df.setLenient(true);
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.DateStringValidator";
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] stringArray = this.pp.getStrings(this.getKey());
            Date[] dateArray = new Date[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                dateArray[n] = this.getDate(stringArray[n]);
                ++n;
            }
            this.setTestValue(dateArray);
        } else {
            this.setTestValue(this.getDate(this.pp.getString(this.getKey())));
        }
    }

    private Date getDate(String string) {
        Date date = null;
        try {
            date = this.validator != null && this.validator instanceof DateStringValidator ? ((DateStringValidator)this.validator).parse(string) : this.df.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public String toString() {
        String string = null;
        Object object = this.getValue();
        string = object == null ? "" : (object instanceof String ? (String)object : (this.validator != null && this.validator instanceof DateStringValidator ? ((DateStringValidator)this.validator).format((Date)object) : this.df.format((Date)object)));
        return string;
    }
}

