/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.commons.fileupload.FileItem;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.FileValidator;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.util.parser.ParameterParser;
import org.apache.fulcrum.util.parser.ValueParser;

public class FileItemField
extends Field {
    public FileItemField(XmlField xmlField, Group group) throws Exception {
        super(xmlField, group);
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.FileValidator";
    }

    public Field init(ValueParser valueParser) throws ServiceException {
        try {
            this.pp = (ParameterParser)valueParser;
        }
        catch (ClassCastException classCastException) {
            throw new ServiceException("FileItemFields can only be used with ParameterParser");
        }
        this.valid_flag = true;
        if (this.pp.containsKey(this.getKey())) {
            this.set_flag = true;
            this.validate(this.pp);
        }
        this.initialized = true;
        return this;
    }

    protected boolean validate() {
        ParameterParser parameterParser = (ParameterParser)this.pp;
        if (this.isMultiValued) {
            FileItem[] fileItemArray = parameterParser.getFileItems(this.getKey());
            if (fileItemArray.length == 0) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                int n = 0;
                while (n < fileItemArray.length) {
                    try {
                        ((FileValidator)this.validator).assertValidity(fileItemArray[n]);
                    }
                    catch (ValidationException validationException) {
                        this.setMessage(validationException.getMessage());
                    }
                    ++n;
                }
            }
            if (this.set_flag && this.valid_flag) {
                this.doSetValue(parameterParser);
            }
        } else {
            FileItem fileItem = parameterParser.getFileItem(this.getKey());
            if (fileItem == null || fileItem.getSize() == 0L) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                try {
                    ((FileValidator)this.validator).assertValidity(fileItem);
                    if (this.set_flag) {
                        this.doSetValue(parameterParser);
                    }
                }
                catch (ValidationException validationException) {
                    this.setMessage(validationException.getMessage());
                }
            } else if (this.set_flag) {
                this.doSetValue(parameterParser);
            }
        }
        return this.valid_flag;
    }

    protected void doSetValue() {
        ParameterParser parameterParser = (ParameterParser)this.pp;
        if (this.isMultiValued) {
            this.setTestValue(parameterParser.getFileItems(this.getKey()));
        } else {
            this.setTestValue(parameterParser.getFileItem(this.getKey()));
        }
    }
}

